/*
 * Decompiled with CFR 0.152.
 */
package ventus.util;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.sqlite.SQLiteJDBCLoader;

public class Sqlite3Util {
    public static boolean initWithFallback(File altTmpDir) {
        String orgSqliteTmpdir = "org.sqlite.tmpdir";
        try {
            if (SQLiteJDBCLoader.initialize()) {
                return true;
            }
            throw new IllegalStateException("Unable to initialize JDBC");
        }
        catch (Exception e) {
            e.printStackTrace();
            if (System.getProperty("org.sqlite.tmpdir") != null || altTmpDir == null) {
                return false;
            }
            try {
                System.setProperty("org.sqlite.tmpdir", altTmpDir.getPath());
                return SQLiteJDBCLoader.initialize();
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return false;
            }
        }
    }

    public static boolean tableExists(Connection conn, String tableName) throws SQLException {
        boolean exists = false;
        try (ResultSet rs = conn.getMetaData().getTables(null, null, tableName, null);){
            while (rs.next()) {
                String name = rs.getString("TABLE_NAME");
                if (name == null || !name.equals(tableName)) continue;
                exists = true;
                break;
            }
        }
        return exists;
    }
}

