/*
 * Decompiled with CFR 0.152.
 */
package ventus.util;

import java.awt.Component;
import java.awt.Point;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.SetActiveFloor;
import ventus.actions.Undo;
import ventus.data.VentusData;
import ventus.data.schematics.Floor;
import ventus.data.schematics.FloorOptions;
import ventus.mv.ModelView;
import ventus.mv.displays.GlobalDisplayMgr;

public class MerlinSelectionLogic {
    public void handleSelectionSingle(VentusApp app, VentusData data, Component owner, Point ptScreen, boolean addToSel, boolean selectParent, boolean editObjs, boolean showMeta, Collection<?> hitObjs) {
        try (VentusData.WriteLock lock = data.lockWrite();){
            Object selObj = null;
            if (!hitObjs.isEmpty()) {
                selObj = hitObjs.iterator().next();
                if (!MerlinSelectionLogic.getFilter(data).test(selObj)) {
                    selObj = null;
                }
            }
            if (!showMeta || showMeta && (selObj == null || !data.selection.isSelected(selObj))) {
                this.handleSelection(addToSel, selectParent, Arrays.asList(selObj));
            }
        }
        if (showMeta) {
            this.showContextMenu(app, data, owner, ptScreen);
        }
    }

    public void handleSelectionMultiple(VentusApp app, VentusData data, Component owner, Point ptScreen, boolean addToSel, boolean selectParent, boolean editObjs, boolean showMeta, Collection<?> hitObjs) {
        hitObjs = theUtil.filter(hitObjs, MerlinSelectionLogic.getFilter(data));
        try (VentusData.WriteLock lock = data.lockWrite();){
            this.handleSelection(addToSel, selectParent, hitObjs);
        }
        if (showMeta) {
            this.showContextMenu(app, data, owner, ptScreen);
        }
    }

    private void showContextMenu(VentusApp app, VentusData md, Component owner, Point ptScreen) {
        JPopupMenu menu = app.getContextMenu();
        if (menu != null) {
            md.ui(() -> {
                Point pt = new Point(ptScreen.x, ptScreen.y);
                SwingUtilities.convertPointFromScreen(pt, owner);
                menu.show(owner, pt.x, pt.y);
            });
        }
    }

    private void handleSelection(boolean addToSel, boolean selectParent, Collection<?> objs) {
        Undo.begin(Intl.intl("Select Objects"));
        VentusData data = VentusApp.getApp().getData();
        boolean modified = false;
        Undo.insertUndoEntry_restoreSelection(data);
        if (!addToSel) {
            if (!data.selection.isEmpty()) {
                modified = true;
            }
            data.selection.clear();
        }
        if (objs != null) {
            IdentityHashSet hitObjs = new IdentityHashSet(objs);
            LinkedIdentityHashSet objsToSelect = new LinkedIdentityHashSet();
            LinkedIdentityHashSet objsToDeselect = new LinkedIdentityHashSet();
            for (Object target : objs) {
                Object parent;
                if (target == null) continue;
                boolean select = true;
                if (selectParent && (parent = data.hierarchy.getParent(target)) != null) {
                    target = parent;
                }
                if (addToSel) {
                    Object[] pathFromRoot = data.hierarchy.getPath(target);
                    pathFromRoot = Arrays.copyOf(pathFromRoot, pathFromRoot.length - 1);
                    boolean foundSelectedParent = false;
                    if (pathFromRoot != null && !selectParent) {
                        for (int j = 0; j < pathFromRoot.length; ++j) {
                            if (!foundSelectedParent && !data.selection.isSelected(pathFromRoot[j])) continue;
                            foundSelectedParent = true;
                            objsToSelect.remove(pathFromRoot[j]);
                            objsToDeselect.add(pathFromRoot[j]);
                            for (Object member : data.hierarchy.getChildren(pathFromRoot[j])) {
                                if ((j >= pathFromRoot.length - 1 || member == pathFromRoot[j + 1]) && (j != pathFromRoot.length - 1 || hitObjs.contains(member))) continue;
                                objsToDeselect.remove(member);
                                objsToSelect.add(member);
                            }
                        }
                        select = false;
                    }
                    if (!foundSelectedParent) {
                        boolean bl = select = !data.selection.isSelected(target);
                    }
                }
                if (select) {
                    objsToDeselect.remove(target);
                    objsToSelect.add(target);
                    continue;
                }
                objsToSelect.remove(target);
                objsToDeselect.add(target);
            }
            if (!objsToSelect.isEmpty() || !objsToDeselect.isEmpty()) {
                modified = true;
                data.selection.deselectAll(objsToDeselect);
                data.selection.selectAll(objsToSelect);
            }
        }
        Undo.end(data, modified);
    }

    private static Predicate<Object> getFilter(VentusData d_data) {
        boolean limitToActiveFloor;
        Collection<Floor> floors = d_data.floors.getMembers(Floor.class);
        Optional<Floor> belowActive = SetActiveFloor.getFloorBelow(d_data, d_data.floors.getActive());
        boolean bl = limitToActiveFloor = d_data.floorOptions.get(FloorOptions.SHOW_LOWER_FLOOR) != false && d_data.floorOptions.get(FloorOptions.LIMIT_SELECTION_TO_ACTIVE) != false && floors.stream().allMatch(f -> {
            boolean shouldBeVisible = f == d_data.floors.getActive() || belowActive.isPresent() && belowActive.get() == f;
            return shouldBeVisible == f.isVisible();
        });
        if (limitToActiveFloor) {
            Floor active = d_data.floors.getActive();
            ConvexHull ch = d_data.floors.getSingleFloorClippingRegion(active);
            ModelView mv = VentusApp.getAppOpt().map(VentusApp::getModelView).orElse(null);
            if (ch.acceptsAll() || mv == null) {
                return obj -> !d_data.hierarchy.isDescendent(d_data.floors, obj) || d_data.hierarchy.isDescendent(active, obj);
            }
            GlobalDisplayMgr dispMgr = mv.getDisplayManager();
            return obj -> {
                AABox bounds;
                if (d_data.hierarchy.isDescendent(d_data.floors, obj)) {
                    return d_data.hierarchy.isDescendent(active, obj);
                }
                if (dispMgr.isClippedByFloor(obj) && (bounds = d_data.geomLocation.getBounds(obj)) != null) {
                    return ch.test((AABox)bounds).positive;
                }
                return true;
            };
        }
        return Filters.acceptAll();
    }
}

