/*
 * Decompiled with CFR 0.152.
 */
package ventus.util;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Observer;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.Semaphore;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.theObservable;

public class MerlinProps
extends theObservable
implements IPropertySet {
    private final Stack<Object> d_sourceStack = new Stack();
    private final Map<Object, Collection<Object>> d_changedObjs = new LinkedIdentityHashMap<Object, Collection<Object>>();
    private final Semaphore d_lock = new Semaphore(1);
    private final IPropertySet d_props = new PropertySet();

    protected boolean lock() {
        return this.d_lock.tryAcquire();
    }

    protected void release() {
        this.d_lock.release();
    }

    @Override
    public <T> T get(IPropertySet.Prop<T> prop) {
        return this.d_props.get(prop);
    }

    @Override
    public <T> boolean isDefined(IPropertySet.Prop<T> prop) {
        return this.d_props.isDefined(prop);
    }

    @Override
    public <T> void set(IPropertySet.Prop<T> prop, T val) {
        if (!this.lock()) {
            return;
        }
        try {
            this.d_props.set(prop, val);
            this.firePropChanged(prop);
        }
        finally {
            this.release();
        }
    }

    @Override
    public <T> void remove(IPropertySet.Prop<T> prop) {
        if (!this.lock()) {
            return;
        }
        try {
            this.d_props.remove(prop);
            this.firePropChanged(prop);
        }
        finally {
            this.release();
        }
    }

    @Override
    public void pause() {
        this.pause(null);
    }

    public void pause(Object source) {
        super.pause();
        this.d_sourceStack.push(source);
    }

    @Override
    public boolean resume() {
        this.d_sourceStack.pop();
        return super.resume();
    }

    public Object getCurrentSource() {
        for (int m = this.d_sourceStack.size() - 1; m >= 0; --m) {
            Object src = this.d_sourceStack.get(m);
            if (src == null) continue;
            return src;
        }
        return null;
    }

    @Override
    public synchronized boolean hasChanged() {
        return !this.d_changedObjs.isEmpty();
    }

    protected boolean firePropChanged(Object prop) {
        return this.firePropChanged(null, prop);
    }

    protected boolean firePropChanged(Object source, Object prop) {
        Collection<Object> sources = this.d_changedObjs.get(prop);
        if (sources == null) {
            sources = new LinkedList<Object>();
            this.d_changedObjs.put(prop, sources);
        }
        if (source == null) {
            source = this.getCurrentSource();
        }
        if (source != null) {
            sources.add(source);
        }
        return this.tryFireNotification(null);
    }

    @Override
    protected boolean tryFireNotification(Object arg) {
        if (super.tryFireNotification(this.d_changedObjs)) {
            this.d_changedObjs.clear();
            return true;
        }
        return false;
    }

    public boolean propChanged(Object prop) {
        return this.d_changedObjs.containsKey(prop);
    }

    public boolean aPropChanged(Object ... props) {
        for (Object p : props) {
            if (!this.d_changedObjs.containsKey(p)) continue;
            return true;
        }
        return false;
    }

    public Set<Object> getChanges() {
        return Collections.unmodifiableSet(this.d_changedObjs.keySet());
    }

    public Collection<Object> getSources(Object change) {
        return this.d_changedObjs.get(change);
    }

    public boolean wasSource(Object source) {
        for (Collection<Object> sources : this.d_changedObjs.values()) {
            if (!sources.contains(source)) continue;
            return true;
        }
        return false;
    }

    public static class WeakRef<T extends MerlinProps> {
        private T d_props = null;
        private final Observer d_observer;

        public WeakRef(Observer obs) {
            this.d_observer = obs;
        }

        public void removeAsObserver() {
            if (this.d_props != null) {
                ((theObservable)this.d_props).deleteObserver(this.d_observer);
            }
        }

        public void addAsObserver() {
            if (this.d_props != null) {
                ((theObservable)this.d_props).addWeakObserver(this.d_observer);
            }
        }

        public boolean set(T props) {
            if (this.d_props != props) {
                if (props != null) {
                    ((theObservable)props).addWeakObserver(this.d_observer);
                }
                if (this.d_props != null) {
                    ((theObservable)this.d_props).deleteObserver(this.d_observer);
                }
                this.d_props = props;
                return true;
            }
            return false;
        }

        public T val() {
            return this.d_props;
        }

        public boolean isNull() {
            return this.d_props == null;
        }
    }
}

