/*
 * Decompiled with CFR 0.152.
 */
package ventus.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleBiFunction;
import java.util.function.ToDoubleFunction;

public class AStar {
    public static <NodeT> IAStarResult getPath(NodeT start, Function<NodeT, ? extends Collection<? extends NodeT>> getAdjacentNodes, ToDoubleFunction<NodeT> heuristic, ToDoubleBiFunction<NodeT, NodeT> cost, Predicate<NodeT> goalReached) {
        double startH = heuristic.applyAsDouble(start);
        PriorityQueue<ANode<NodeT>> open = new PriorityQueue<ANode<NodeT>>();
        HashSet<NodeT> closed = new HashSet<NodeT>();
        int failures = 0;
        ANode goalNode = null;
        ANode<NodeT> startNode = new ANode<NodeT>(null, start, 0.0, startH);
        open.add(startNode);
        closed.add(startNode.node);
        while (!open.isEmpty()) {
            ANode anode = (ANode)open.remove();
            Object node = anode.node;
            if (goalReached.test(node)) {
                goalNode = anode;
                break;
            }
            for (NodeT adjNode : getAdjacentNodes.apply(node)) {
                if (!closed.add(adjNode)) continue;
                double h = heuristic.applyAsDouble(adjNode);
                double g = cost.applyAsDouble(node, adjNode);
                ANode<NodeT> nextANode = new ANode<NodeT>(anode, adjNode, g, h);
                open.add(nextANode);
            }
        }
        if (goalNode != null) {
            return new AStarSuccess(goalNode);
        }
        return new AStarFailure(failures);
    }

    public static class ANode<NodeT>
    implements Comparable<ANode<NodeT>> {
        public final ANode<NodeT> parent;
        public final NodeT node;
        public final double g;
        public final double f;

        public ANode(ANode<NodeT> parent, NodeT node, double g, double h) {
            this.parent = parent;
            this.node = node;
            this.g = g;
            this.f = g + h;
        }

        public int getPathCount() {
            int count = 1;
            ANode<NodeT> node = this.parent;
            while (node != null) {
                ++count;
                node = node.parent;
            }
            return count;
        }

        @Override
        public int compareTo(ANode<NodeT> o) {
            int result = Double.compare(this.f, o.f);
            if (result == 0) {
                if (this.equals(o)) {
                    return 0;
                }
                int count1 = this.getPathCount();
                int count2 = o.getPathCount();
                return Integer.signum(count1 - count2);
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ANode)) {
                return false;
            }
            ANode node = (ANode)obj;
            boolean result = this.g == node.g && this.f == node.f && Objects.equals(this.node, node.node) && Objects.equals(this.parent, node.parent);
            return result;
        }
    }

    public static class AStarSuccess
    implements IAStarResult {
        public final ANode<?> node;

        public AStarSuccess(ANode<?> node) {
            this.node = node;
        }
    }

    public static class AStarFailure
    implements IAStarResult {
        public static final int BOUNDARY = 1;
        public static final int EDGE_FILTERED = 4;
        public final int types;

        public AStarFailure(int types) {
            this.types = types;
        }

        public boolean test(int type) {
            return (this.types & type) == type;
        }

        public boolean testBoundary() {
            return this.test(1);
        }

        public boolean testEdgeFiltered() {
            return this.test(4);
        }
    }

    public static interface IAStarResult {
    }
}

