/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.tools;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.scene3d.picking.PlanarConstraint;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;
import ventus.VentusApp;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.mv.tools.RoomSnapConstraint;

public class RoomLocFunc<T extends CursorTool>
extends AToolFunction<T> {
    private boolean d_p0Set = false;
    private final Function<T, Plane3d> d_getP0Plane;
    private final BiConsumer<T, Iterable<Location>> d_setLoc;
    private final BiConsumer<T, Component> d_createIfValid;
    private final BiConsumer<T, Point3d> d_updateDrag;
    private final Consumer<T> d_cancel;
    private final BiPredicate<? super ISchematicRoom, ? super ISchematicRoom.IComponent> d_roomFilter;

    public RoomLocFunc(BiConsumer<T, Iterable<Location>> setLoc, BiConsumer<T, Component> createIfValid, BiPredicate<? super ISchematicRoom, ? super ISchematicRoom.IComponent> roomFilter) {
        this(setLoc, null, null, createIfValid, null, roomFilter);
    }

    public RoomLocFunc(BiConsumer<T, Iterable<Location>> setLoc, BiConsumer<T, Component> createIfValid, Consumer<T> cancel, BiPredicate<? super ISchematicRoom, ? super ISchematicRoom.IComponent> roomFilter) {
        this(setLoc, null, null, createIfValid, cancel, roomFilter);
    }

    public RoomLocFunc(BiConsumer<T, Iterable<Location>> setLoc, Function<T, Plane3d> getP0Plane, BiConsumer<T, Point3d> updateDrag, BiConsumer<T, Component> createIfValid, Consumer<T> d_cancel, BiPredicate<? super ISchematicRoom, ? super ISchematicRoom.IComponent> roomFilter) {
        this.d_getP0Plane = getP0Plane;
        this.d_setLoc = setLoc;
        this.d_createIfValid = createIfValid;
        this.d_updateDrag = updateDrag;
        this.d_cancel = d_cancel;
        this.d_roomFilter = roomFilter;
    }

    @Override
    public Pair<SnapMode, IIsectFilter> getSnapInfo(T tool) {
        return new Pair<SnapMode, IIsectFilter>(SnapMode.FILTERED_TWO_PASS, new DefaultFilter());
    }

    @Override
    public Cursor getCursor(T tool) {
        return null;
    }

    private boolean isDragModeEnabled(T tool) {
        return this.d_getP0Plane != null && this.d_updateDrag != null;
    }

    private boolean isSettingMeta(T tool) {
        return this.isDragModeEnabled(tool) && this.d_p0Set && ((CursorTool)tool).isDragging(1) && ((CursorTool)tool).dragAboveTolerance(0);
    }

    @Override
    public ISnapConstraint getSnapConstraint(T tool) {
        if (!this.isSettingMeta(tool)) {
            return new RoomSnapConstraint(VentusApp.getAppData(), null, this.d_roomFilter);
        }
        Plane3d plane = this.d_getP0Plane.apply(tool);
        return new PlanarConstraint(plane);
    }

    private void updateLocation(T tool) {
        Collection<Location> locs;
        Collection<IsectInfo> isects = ((CursorTool)tool).getP1().getFinalSnaps();
        if (!isects.isEmpty() && !(locs = theUtil.map(theUtil.preFilter(isects, IsectInfo.class, snap -> snap.obj instanceof ISchematicRoom && snap.getFaceNormal != null), snap -> {
            ISchematicRoom room = (ISchematicRoom)snap.obj;
            return new Location(room, snap.getFaceNormal.get(), snap.isectPoint, snap.elements.getElement(ISchematicRoom.COMPONENT_ELEMENT));
        })).isEmpty()) {
            this.d_setLoc.accept(tool, locs);
            this.d_p0Set = true;
            return;
        }
        this.d_setLoc.accept(tool, Collections.singleton(new Location(null, GeomConstants.VEC3D_ZPOS, ((CursorTool)tool).getP1().referenceSnap, Optional.empty())));
    }

    @Override
    public void mouseMoved(T tool, MouseEvent e) {
        this.updateLocation(tool);
    }

    @Override
    public void mousePressed(T tool, MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        this.updateLocation(tool);
    }

    @Override
    public void mouseReleased(T tool, MouseEvent e) {
        if (e.getButton() == 3) {
            ((CursorTool)tool).cancel();
            if (this.d_cancel != null) {
                this.d_cancel.accept(tool);
            }
            return;
        }
        if (!this.d_p0Set || e.getButton() != 1) {
            return;
        }
        this.d_createIfValid.accept(tool, e.getComponent());
        this.d_p0Set = false;
    }

    @Override
    public void mouseDragged(T tool, MouseEvent e) {
        if (!this.isSettingMeta(tool)) {
            if (!this.isDragModeEnabled(tool)) {
                this.updateLocation(tool);
            }
            return;
        }
        Point3d p1 = ((CursorTool)tool).getP1().getFinalSnapLocation();
        if (p1 != null) {
            this.d_updateDrag.accept(tool, p1);
        }
    }

    public static class Location {
        public final ISchematicRoom room;
        public final Vector3d normal;
        public final Point3d loc;
        public final Optional<ISchematicRoom.IComponent> component;

        public Location(ISchematicRoom room, Vector3d normal, Point3d loc, Optional<ISchematicRoom.IComponent> component) {
            this.room = room;
            this.normal = normal;
            this.loc = loc;
            this.component = component;
        }

        public boolean isValid() {
            return this.room != null;
        }
    }
}

