/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.tools;

import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.KeyStroke;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.Shortcut;
import ventus.actions.VentusShortcuts;
import ventus.builders.PolyBuilder;
import ventus.mv.ModelView;
import ventus.mv.tools.NewPlanarGeomTool;

public class NewPolyTool
extends NewPlanarGeomTool<PolyBuilder> {
    public NewPolyTool(ModelView mv) {
        super(mv, new Func());
        this.setCancelOnRightClick(false);
    }

    private void addTestPoint(Point2d p) {
        if (p == null) {
            return;
        }
        ((PolyBuilder)this.props()).addTestPoint(p);
    }

    @Override
    public boolean cancel() {
        ((PolyBuilder)this.props()).cancel();
        return super.cancel();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        super.keyPressed(e);
        switch (e.getKeyCode()) {
            case 10: {
                ((PolyBuilder)this.props()).closePoly(e.getComponent());
            }
        }
        if (this.isToolUndoEvent(e, (PolyBuilder)this.props())) {
            ((PolyBuilder)this.props()).undo();
            this.repaintSurface();
        }
        if (this.isToolRedoEvent(e, (PolyBuilder)this.props())) {
            ((PolyBuilder)this.props()).redo();
            this.repaintSurface();
        }
    }

    @Override
    public boolean consumeKeyEvent(KeyEvent e) {
        return super.consumeKeyEvent(e) || this.isToolUndoEvent(e, (PolyBuilder)this.props()) || this.isToolRedoEvent(e, (PolyBuilder)this.props());
    }

    private boolean isToolUndoEvent(KeyEvent evt, PolyBuilder builder) {
        return NewPolyTool.isShortcutEvent(VentusShortcuts.UNDO, evt);
    }

    private boolean isToolRedoEvent(KeyEvent evt, PolyBuilder builder) {
        return NewPolyTool.isShortcutEvent(VentusShortcuts.REDO, evt);
    }

    private static boolean isShortcutEvent(Shortcut sc, KeyEvent evt) {
        if (VentusApp.getApp() == null) {
            return false;
        }
        KeyStroke ks = VentusApp.getApp().getHotkeys().getUiHelper().getKeyStrokeForID(sc.getKey());
        KeyStroke ksEv = KeyStroke.getKeyStrokeForEvent(evt);
        return ks != null && ks.equals(ksEv);
    }

    @Override
    protected String getShapeName() {
        return Intl.intl("Polygon");
    }

    @Override
    protected String getStatusMessage() {
        List<Point2d> points = ((PolyBuilder)this.props()).getPoints();
        int num = points.size();
        Point3d nextPoint = points.isEmpty() ? this.getAddLoc() : this.getLoc(points.get(points.size() - 1));
        return nextPoint == null ? "" : String.format(Intl.intl("Polygon - Point %d: %s"), num, this.toString(nextPoint));
    }

    protected static class Func
    extends NewPlanarGeomTool.Func<PolyBuilder, NewPolyTool> {
        protected Func() {
        }

        @Override
        public Cursor getCursor(NewPolyTool tool) {
            return null;
        }

        @Override
        public void mouseExited(NewPolyTool tool, MouseEvent e) {
            ((PolyBuilder)tool.props()).cancelTestPoint();
        }

        @Override
        public void mouseMoved(NewPolyTool tool, MouseEvent e) {
            if (((PolyBuilder)tool.props()).isComplete()) {
                return;
            }
            ((PolyBuilder)tool.props()).pause();
            Point2d addLoc = tool.getPlanarAddLoc();
            if (addLoc != null) {
                ((PolyBuilder)tool.props()).cancelTestPoint();
                tool.addTestPoint(addLoc);
            }
            ((PolyBuilder)tool.props()).resume();
        }

        @Override
        public void mouseReleased(NewPolyTool tool, MouseEvent e) {
            switch (e.getButton()) {
                case 1: {
                    Point2d addPoint = tool.getPlanarAddLoc();
                    if (addPoint == null) break;
                    ((PolyBuilder)tool.props()).addPoint(addPoint);
                    break;
                }
                case 3: {
                    if (((PolyBuilder)tool.props()).canClosePoly()) {
                        ((PolyBuilder)tool.props()).closePoly(e.getComponent());
                        tool.finish();
                        break;
                    }
                    ((PolyBuilder)tool.props()).cancel();
                    tool.cancel();
                }
            }
        }
    }
}

