/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.manip;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import thunderheadeng.geometry.IMutableGeomSrc;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.IDisplayMgr;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.scene3d.manip.HandleEvent;
import thunderheadeng.scene3d.manip.HandleGroup;
import thunderheadeng.scene3d.manip.HandleMgr;
import thunderheadeng.scene3d.manip.IHandleListener;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventRecord;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.FloorSortActions;
import ventus.actions.SubtractAction;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.geom.ISchematicComp;
import ventus.data.schematics.geom.SchematicRoom;
import ventus.gui.IPropEditor;
import ventus.gui.PropPanel;
import ventus.mv.ModelView;
import ventus.mv.displays.GlobalDisplayMgr;
import ventus.mv.displays.HandleDispMgr;
import ventus.mv.gui.HandleManipPanel;

public class ManipHook
implements IHandleListener {
    private final ModelView d_mv;
    private final HandleMgr d_handleMgr;
    private IPropEditor d_nullPanel;
    private final HandleManipPanel d_handleManipPanel;

    public ManipHook(final VentusData domain, ModelView mv, GlobalDisplayMgr dispMgr, ModelScene handleScene) {
        this.d_mv = mv;
        HandleDispMgr handleDispMgr = new HandleDispMgr(domain, handleScene);
        this.d_handleMgr = new HandleMgr(domain.getEvents(), VentusApp.getApp().getPrefs(), dispMgr, handleDispMgr, new HandleMgr.IAppHook(){

            @Override
            public void addSearch(IDisplayableGeomSrc obj) {
                domain.geomLocation.add(obj);
            }

            @Override
            public void removeSearch(IDisplayableGeomSrc obj) {
                domain.geomLocation.remove(obj);
            }

            @Override
            public <T> Set<T> getSelected(Class<T> type) {
                return domain.selection.getSelected(type);
            }

            @Override
            public boolean isResetEvent(Events events) {
                IEventRecord<VentusData> merlinEvts = events.getEvents(VentusData.class, new Class[0]);
                return merlinEvts.containsChange(VentusData.MODEL_RESET) || merlinEvts.containsChange(VentusData.MODEL_LOADED);
            }

            @Override
            public <T> boolean isSelectionEvent(IEventRecord<T> pevts) {
                return pevts.containsChange(VentusData.SELECTION_CHANGED);
            }

            @Override
            public void updateVisibilityIfNeeded(Events events, IDisplayMgr<HandleGroup> handleDispMgr) {
                ((HandleDispMgr)handleDispMgr).updateVisIfModified(events);
            }
        });
        this.d_handleManipPanel = new HandleManipPanel(this.d_handleMgr, this.d_mv.getRenderComp());
        this.d_handleMgr.addListener(this);
    }

    public HandleMgr getManager() {
        return this.d_handleMgr;
    }

    protected void updateHandles() {
        if (this.d_handleMgr.isModifying()) {
            this.d_handleManipPanel.update();
        }
    }

    protected void begin() {
        PropPanel toolPropsPanel = this.d_mv.getToolPropsPanel();
        this.d_nullPanel = toolPropsPanel.getEditor();
        this.d_handleManipPanel.update();
        toolPropsPanel.setEditor(this.d_handleManipPanel);
    }

    protected void end() {
        PropPanel toolPropsPanel = this.d_mv.getToolPropsPanel();
        toolPropsPanel.setEditor(this.d_nullPanel);
    }

    protected void commit(IMutableGeomSrc src, IGeomNode newNode) {
        UIHook.run((Component)null, "ManipListener.commit", new CommitTask(src, newNode), 0);
    }

    @Override
    public void handleChanged(HandleEvent evt) {
        HandleEvent.Type type = evt.getType();
        switch (type) {
            case MOD_STARTED: {
                this.begin();
                break;
            }
            case HANDLES_MODIFIED: {
                this.updateHandles();
                break;
            }
            case ACTIVE_HANDLE_CHANGED: {
                break;
            }
            case MOD_ENDED: {
                this.end();
                if (!evt.isCommitted()) break;
                this.commit(this.d_handleMgr.getCurrentSourceObj(), evt.getNewNode());
                break;
            }
        }
    }

    private static class CommitTask
    extends AMerlinOp {
        private final IMutableGeomSrc d_src;
        private final IGeomNode d_newNode;

        public CommitTask(IMutableGeomSrc src, IGeomNode newNode) {
            this.d_src = src;
            this.d_newNode = newNode;
        }

        @Override
        public void run(VentusApp app, VentusData md) {
            try (VentusData.WriteLock lock = md.lockWrite();){
                IMutableGeomSrc iMutableGeomSrc;
                Undo.begin(Intl.intl("Edit"));
                IMutableGeomSrc iMutableGeomSrc2 = this.d_src;
                if (iMutableGeomSrc2 instanceof IMerlinObj) {
                    IMerlinObj mobj = (IMerlinObj)((Object)iMutableGeomSrc2);
                    Undo.insertUndoEntry_restore(md, mobj);
                } else {
                    Undo.insertEntry_breakChain(md);
                }
                this.d_src.setGeom(this.d_newNode);
                ArrayList<SchematicRoom> toClean = new ArrayList<SchematicRoom>();
                if (this.d_src instanceof SchematicRoom) {
                    SubtractAction.subtract(app, md, 0, toClean::add, (SchematicRoom)this.d_src);
                    if (!toClean.contains(this.d_src)) {
                        toClean.add((SchematicRoom)this.d_src);
                    }
                }
                if ((iMutableGeomSrc = this.d_src) instanceof IMerlinObj) {
                    IMerlinObj mobj = (IMerlinObj)((Object)iMutableGeomSrc);
                    Collection<ISchematicComp> sortable = FloorSortActions.getSortableObjs(md, List.of(mobj));
                    FloorSortActions.updateComponentFloors(md, sortable);
                }
                SchematicRoom.cleanup(md, toClean);
                Undo.end(md);
            }
        }
    }
}

