/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.gui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.scene3d.picking.PlanarConstraint;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class ZLevelLocFunc<T extends CursorTool>
extends AToolFunction<T> {
    private boolean d_p0Set = false;
    private final BiConsumer<T, Iterable<Point3d>> d_setLoc;
    private final BiConsumer<T, Component> d_createIfValid;
    private final Function<T, Double> d_getZ;

    public ZLevelLocFunc(BiConsumer<T, Iterable<Point3d>> setLoc, BiConsumer<T, Component> createIfValid, Function<T, Double> getZ) {
        this.d_setLoc = setLoc;
        this.d_createIfValid = createIfValid;
        this.d_getZ = getZ;
    }

    @Override
    public Pair<SnapMode, IIsectFilter> getSnapInfo(T tool) {
        return new Pair<SnapMode, IIsectFilter>(SnapMode.FILTERED_TWO_PASS, new DefaultFilter());
    }

    @Override
    public Cursor getCursor(T tool) {
        return null;
    }

    @Override
    public ISnapConstraint getSnapConstraint(T tool) {
        return new PlanarConstraint(new Plane3d(new Vector3d(0.0, 0.0, 1.0), new Point3d(0.0, 0.0, this.d_getZ.apply(tool))));
    }

    private void updateLocation(T tool) {
        Collection<Point3d> locs;
        Collection<IsectInfo> isects = ((CursorTool)tool).getP1().getFinalSnaps();
        if (!isects.isEmpty() && !(locs = theUtil.map(isects, snap -> snap.isectPoint)).isEmpty()) {
            this.d_setLoc.accept(tool, locs);
            this.d_p0Set = true;
            return;
        }
        this.d_setLoc.accept(tool, Collections.singleton(((CursorTool)tool).getP0().getFinalSnapLocation()));
    }

    @Override
    public void mouseMoved(T tool, MouseEvent e) {
        this.updateLocation(tool);
    }

    @Override
    public void mousePressed(T tool, MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        this.updateLocation(tool);
    }

    @Override
    public void mouseReleased(T tool, MouseEvent e) {
        if (!this.d_p0Set || e.getButton() != 1) {
            return;
        }
        this.d_createIfValid.accept(tool, e.getComponent());
        this.d_p0Set = false;
    }

    @Override
    public void mouseDragged(T tool, MouseEvent e) {
    }
}

