/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.gui;

import java.util.function.BiPredicate;
import java.util.function.Function;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.QuadConsumer;
import ventus.VentusApp;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.geom.GeomUtil;
import ventus.geom.Geometry;
import ventus.mv.gui.LocationPanel;
import ventus.util.MerlinProps;

public class RoomLocPanel<T extends MerlinProps>
extends LocationPanel<T> {
    private static final long serialVersionUID = 1L;
    private final QuadConsumer<T, ISchematicRoom, Vector3d, UnitPoint3D> d_setLocation;
    private final Function<T, UnitPoint3D> d_getLocation;
    private final BiPredicate<? super ISchematicRoom, ? super ISchematicRoom.IComponent> d_roomFilter;

    public RoomLocPanel(QuadConsumer<T, ISchematicRoom, Vector3d, UnitPoint3D> setLocation, Function<T, UnitPoint3D> getLocation, BiPredicate<? super ISchematicRoom, ? super ISchematicRoom.IComponent> roomFilter, Object ... interestingChanges) {
        super(1, interestingChanges);
        this.d_setLocation = setLocation;
        this.d_getLocation = getLocation;
        this.d_roomFilter = roomFilter;
    }

    @Override
    protected void updateToProps(T props) {
        UnitPoint3D specPoint = this.getValue();
        Point3d p1 = specPoint.getPoint3dValue(Geometry.LENGTH_UNIT);
        p1.z += 1.0E-6;
        AABox modelBounds = VentusApp.getApp().getData().geomLocation.getBounds();
        Point3d p2 = new Point3d(p1.x, p1.y, modelBounds.getMinZ() - 1.0E-6);
        GeomUtil.FindResult findResult = GeomUtil.findRoom(VentusApp.getApp().getData(), p1, p2, 1, this.d_roomFilter);
        ISchematicRoom room = findResult != null ? findResult.room : null;
        Vector3d norm = findResult != null ? findResult.faceNormal : GeomConstants.VEC3D_ZPOS;
        UnitPoint3D p = findResult != null ? new UnitPoint3D(findResult.p, Geometry.LENGTH_UNIT) : specPoint;
        this.d_setLocation.accept(props, room, norm, p);
    }

    @Override
    protected void updateFromProps(T props) {
        this.setValue(this.d_getLocation.apply(props));
    }
}

