/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.gui;

import java.awt.GridBagLayout;
import javax.swing.AbstractButton;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.geom.Geometry;
import ventus.gui.APropEditPanel;
import ventus.gui.IPropEditCommand;
import ventus.gui.MerlinUDF;
import ventus.util.MerlinProps;

public class PlanePanel<T extends MerlinProps>
extends APropEditPanel<T> {
    private static final long serialVersionUID = 8348213351773815097L;
    private final guiRadioButton d_aaBtn;
    private final guiRadioButton d_customBtn;
    private final guiRadioButton d_dummyBtn = new guiRadioButton();
    private final guiComboBox<String> d_axisCB;
    private final MerlinUDF d_axisValFld;
    private final MerlinUDF d_x;
    private final MerlinUDF d_y;
    private final MerlinUDF d_z;
    private final MerlinUDF d_w;
    private static final String X = Intl.intl("X");
    private static final String Y = Intl.intl("Y");
    private static final String Z = Intl.intl("Z");

    public PlanePanel(String title, Object ... interestingChanges) {
        this(title, Intl.intl("X"), Intl.intl("Y"), Intl.intl("Z"), Intl.intl("W"), interestingChanges);
    }

    public PlanePanel(String title, String xLbl, String yLbl, String zLbl, String wLbl, Object ... interestingChanges) {
        super(interestingChanges);
        this.d_aaBtn = this.initButton(new guiRadioButton(Intl.intl("Axis-aligned")), new IPropEditCommand[0]);
        this.d_axisCB = this.initComboBox(new guiComboBox<String>((T[])new String[]{X, Y, Z}));
        guiLabel eqLbl = new guiLabel("=");
        this.d_axisValFld = this.initValueField(new MerlinUDF(0), new IPropEditCommand[0]);
        LinkStatus.link((AbstractButton)this.d_aaBtn, this.d_axisCB, eqLbl, this.d_axisValFld);
        this.d_customBtn = this.initButton(new guiRadioButton(Intl.intl("Custom")), new IPropEditCommand[0]);
        guiLabel xlbl = new guiLabel(xLbl + ":");
        guiLabel ylbl = new guiLabel(yLbl + ":");
        guiLabel zlbl = new guiLabel(zLbl + ":");
        guiLabel wlbl = new guiLabel(wLbl + ":");
        this.d_x = this.initValueField(new MerlinUDF(0), new IPropEditCommand[0]);
        this.d_y = this.initValueField(new MerlinUDF(0), new IPropEditCommand[0]);
        this.d_z = this.initValueField(new MerlinUDF(0), new IPropEditCommand[0]);
        this.d_w = this.initValueField(new MerlinUDF(0), new IPropEditCommand[0]);
        LinkStatus.link((AbstractButton)this.d_customBtn, xlbl, this.d_x, ylbl, this.d_y, zlbl, this.d_z, wlbl, this.d_w);
        new guiButtonGroup(this.d_dummyBtn, this.d_aaBtn, this.d_customBtn);
        guiPanel aaPnl = new guiPanel(new GridBagLayout());
        GridBagUtil.add(aaPnl, this.d_axisCB, 0, 0, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(aaPnl, eqLbl, 1, 0, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(aaPnl, this.d_axisValFld, 2, 0, 1, 1, 0, 0, 0, 0, 0, 0.0, 0.0, 17);
        guiPanel customPnl = new guiPanel(new GridBagLayout());
        GridBagUtil.add(customPnl, xlbl, 0, 1, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(customPnl, this.d_x, 1, 1, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(customPnl, ylbl, 2, 1, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(customPnl, this.d_y, 3, 1, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(customPnl, zlbl, 4, 1, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(customPnl, this.d_z, 5, 1, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(customPnl, wlbl, 6, 1, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(customPnl, this.d_w, 7, 1, 1, 1, 0, 0, 0, 0, 0, 0.0, 0.0, 17);
        int row = 0;
        if (title != null) {
            GridBagUtil.add(this, new guiLabel(title), 0, row, 2, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        }
        GridBagUtil.add(this, this.d_aaBtn, 0, ++row, 1, 1, 3, 12, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, aaPnl, 1, row, 1, 1, 3, 0, 0, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_customBtn, 0, ++row, 1, 1, 3, 12, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, customPnl, 1, row, 1, 1, 3, 0, 0, 0, 0, 0.0, 0.0, 17);
    }

    public Plane3d getValue() {
        if (!this.d_aaBtn.isSelected() && !this.d_customBtn.isSelected() || !this.validateData(false, false)) {
            return null;
        }
        if (this.d_aaBtn.isSelected()) {
            double val = ((UnitDouble)this.d_axisValFld.getValue()).getValue(Geometry.LENGTH_UNIT);
            String axis = this.d_axisCB.getSelectedItem();
            if (axis == X) {
                return new Plane3d(1.0, 0.0, 0.0, -val);
            }
            if (axis == Y) {
                return new Plane3d(0.0, 1.0, 0.0, -val);
            }
            return new Plane3d(0.0, 0.0, 1.0, -val);
        }
        double x = ((UnitDouble)this.d_x.getValue()).getValue(Geometry.LENGTH_UNIT);
        double y = ((UnitDouble)this.d_y.getValue()).getValue(Geometry.LENGTH_UNIT);
        double z = ((UnitDouble)this.d_z.getValue()).getValue(Geometry.LENGTH_UNIT);
        double w = ((UnitDouble)this.d_w.getValue()).getValue(Geometry.LENGTH_UNIT);
        return new Plane3d(x, y, z, w);
    }

    private static boolean isConformingPlane(double v1, double v0a, double v0b) {
        return theUtil.eq(Math.abs(v1), 1.0, 1.0E-6) && theUtil.eq0(v0a, 1.0E-6) && theUtil.eq0(v0b, 1.0E-6);
    }

    public void setValue(Plane3d val) {
        if (val == null) {
            this.d_dummyBtn.setSelected(true);
            return;
        }
        double aval = Double.NaN;
        if (PlanePanel.isConformingPlane(val.x, val.y, val.z)) {
            this.d_axisCB.setSelectedItem(X);
            aval = val.x < 0.0 ? val.w : -val.w;
        } else if (PlanePanel.isConformingPlane(val.y, val.x, val.z)) {
            this.d_axisCB.setSelectedItem(Y);
            aval = val.y < 0.0 ? val.w : -val.w;
        } else if (PlanePanel.isConformingPlane(val.z, val.x, val.y)) {
            this.d_axisCB.setSelectedItem(Z);
            double d = aval = val.z < 0.0 ? val.w : -val.w;
        }
        if (!Double.isNaN(aval)) {
            this.d_axisValFld.setValue(new UnitDouble(aval, Geometry.LENGTH_UNIT));
        }
        this.d_x.setValue(new UnitDouble(val.x, Geometry.LENGTH_UNIT));
        this.d_y.setValue(new UnitDouble(val.y, Geometry.LENGTH_UNIT));
        this.d_z.setValue(new UnitDouble(val.z, Geometry.LENGTH_UNIT));
        this.d_w.setValue(new UnitDouble(val.w, Geometry.LENGTH_UNIT));
    }
}

