/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.gui;

import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JButton;
import javax.vecmath.Point2d;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiUnitDoubleField;
import thunderheadeng.units.UnitDouble;
import ventus.Intl;
import ventus.builders.RectBuilder;
import ventus.data.VentusData;
import ventus.geom.Geometry;
import ventus.gui.APropEditPanel;
import ventus.gui.IPropEditCommand;
import ventus.gui.MerlinUDF;
import ventus.mv.gui.NewPlanarGeomPanel;

public class NewRectPanel
extends NewPlanarGeomPanel<RectBuilder> {
    private static final long serialVersionUID = 6143036172886668792L;
    private final LocationPanel d_locPan;
    private final CreateBtnPanel d_createPan;

    public NewRectPanel(VentusData data, guiPanel ... others) {
        super(data, 1);
        for (guiPanel panel : others) {
            this.addSeparator();
            this.addSection(panel);
        }
        this.addSeparator();
        this.d_locPan = new LocationPanel();
        this.addSection(this.d_locPan);
        this.d_createPan = new CreateBtnPanel(this.d_locPan);
        this.addSection(this.d_createPan);
    }

    public static class LocationPanel
    extends APropEditPanel<RectBuilder> {
        private static final long serialVersionUID = -6905484214077923529L;
        private final guiUnitDoubleField d_x1 = this.initValueField(new MerlinUDF(0.0, Geometry.LENGTH_UNIT), new IPropEditCommand[0]);
        private final guiUnitDoubleField d_y1 = this.initValueField(new MerlinUDF(0.0, Geometry.LENGTH_UNIT), new IPropEditCommand[0]);
        private final guiUnitDoubleField d_x2 = this.initValueField(new MerlinUDF(0.0, Geometry.LENGTH_UNIT), new IPropEditCommand[0]);
        private final guiUnitDoubleField d_y2 = this.initValueField(new MerlinUDF(0.0, Geometry.LENGTH_UNIT), new IPropEditCommand[0]);

        public LocationPanel() {
            super(RectBuilder.P1_SET, RectBuilder.P2_SET);
            guiLabel x1Lbl = new guiLabel(Intl.intl("X1:"));
            guiLabel y1Lbl = new guiLabel(Intl.intl("Y1:"));
            guiLabel x2Lbl = new guiLabel(Intl.intl("X2:"));
            guiLabel y2Lbl = new guiLabel(Intl.intl("Y2:"));
            guiPanel coordsPanel = new guiPanel();
            coordsPanel.setLayout(new GridBagLayout());
            GridBagUtil.add(coordsPanel, x1Lbl, 0, 0, 1, 1, 0, 6, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(coordsPanel, this.d_x1, 1, 0, 1, 1, 0, 6, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(coordsPanel, y1Lbl, 2, 0, 1, 1, 0, 12, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(coordsPanel, this.d_y1, 3, 0, 1, 1, 0, 6, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(coordsPanel, x2Lbl, 0, 1, 1, 1, 6, 6, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(coordsPanel, this.d_x2, 1, 1, 1, 1, 6, 6, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(coordsPanel, y2Lbl, 2, 1, 1, 1, 6, 12, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(coordsPanel, this.d_y2, 3, 1, 1, 1, 6, 6, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, coordsPanel, 1, 0, 1, 1, 0, 6, 0, 0, 0, 0.0, 0.0, 17);
        }

        @Override
        protected void updateFromProps(RectBuilder props) {
            if (props.getP1() != null) {
                this.d_x1.setValue(new UnitDouble(props.getP1().x, Geometry.LENGTH_UNIT));
                this.d_y1.setValue(new UnitDouble(props.getP1().y, Geometry.LENGTH_UNIT));
            }
            if (props.getP2() != null) {
                this.d_x2.setValue(new UnitDouble(props.getP2().x, Geometry.LENGTH_UNIT));
                this.d_y2.setValue(new UnitDouble(props.getP2().y, Geometry.LENGTH_UNIT));
            }
        }

        public void setEditable(boolean editable) {
            this.d_x1.setEditable(editable);
            this.d_y1.setEditable(editable);
            this.d_x2.setEditable(editable);
            this.d_y2.setEditable(editable);
        }
    }

    private class CreateBtnPanel
    extends guiPanel {
        private static final long serialVersionUID = 5951364972544355455L;
        private final JButton d_createBtn;
        private final LocationPanel d_locPan;

        public CreateBtnPanel(LocationPanel locPan) {
            super(new GridBagLayout());
            this.d_locPan = locPan;
            this.d_createBtn = (JButton)NewRectPanel.this.initButton(new JButton(Intl.intl("Create")), new IPropEditCommand[]{new IPropEditCommand(){

                @Override
                public void updateProp(Component c, boolean hardValidate) {
                    double x1 = ((UnitDouble)CreateBtnPanel.this.d_locPan.d_x1.getValue()).getValue(Geometry.LENGTH_UNIT);
                    double y1 = ((UnitDouble)CreateBtnPanel.this.d_locPan.d_y1.getValue()).getValue(Geometry.LENGTH_UNIT);
                    double x2 = ((UnitDouble)CreateBtnPanel.this.d_locPan.d_x2.getValue()).getValue(Geometry.LENGTH_UNIT);
                    double y2 = ((UnitDouble)CreateBtnPanel.this.d_locPan.d_y2.getValue()).getValue(Geometry.LENGTH_UNIT);
                    ((RectBuilder)NewRectPanel.this.props()).setP1(new Point2d(x1, y1), true);
                    ((RectBuilder)NewRectPanel.this.props()).setP2(new Point2d(x2, y2), true);
                    ((RectBuilder)NewRectPanel.this.props()).complete(c);
                }
            }});
            GridBagUtil.add(this, this.d_createBtn, 0, 0, 1, 1, 0, 6, 0, 0, 0, 0.0, 0.0, 17);
        }
    }
}

