/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.gui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Observable;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.vecmath.Point2d;
import org.jscience.physics.units.SI;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiUnitDoubleField;
import thunderheadeng.units.UnitDouble;
import ventus.Intl;
import ventus.builders.PolyBuilder;
import ventus.data.VentusData;
import ventus.geom.Geometry;
import ventus.gui.IPropEditCommand;
import ventus.gui.MerlinUDF;
import ventus.mv.gui.NewPlanarGeomPanel;

public class NewPolyPanel
extends NewPlanarGeomPanel<PolyBuilder> {
    private static final long serialVersionUID = -6918335917632741757L;
    public static final int PANEL_ADD_POINT = 8;
    private guiUnitDoubleField d_x;
    private guiUnitDoubleField d_y;
    private JButton d_addPointBtn;
    private JButton d_closePolyBtn;
    private JButton d_cancelPolyBtn;

    public NewPolyPanel(VentusData md, int options, guiPanel ... others) {
        super(md, options);
        for (guiPanel panel : others) {
            this.addSeparator();
            this.addSection(panel);
        }
        if (this.testOption(options, 8)) {
            this.addSeparator();
            this.addAddPointPanel();
        }
        KeyStroke stroke = KeyStroke.getKeyStroke(10, 0, false);
        this.d_x.getInputMap().put(stroke, "AddPtCmd");
        this.d_x.getActionMap().put("AddPtCmd", new AddPtAction());
        this.d_y.getInputMap().put(stroke, "AddPtCmd");
        this.d_y.getActionMap().put("AddPtCmd", new AddPtAction());
    }

    private void addAddPointPanel() {
        this.d_x = this.initValueField(new MerlinUDF(0.0, SI.METER), new IPropEditCommand[0]);
        this.d_y = this.initValueField(new MerlinUDF(0.0, SI.METER), new IPropEditCommand[0]);
        this.d_addPointBtn = this.initButton(new JButton(Intl.intl("Add Point")), new AddPtCmd());
        this.d_closePolyBtn = this.initButton(new JButton(Intl.intl("Close Polygon")), new IPropEditCommand(){

            @Override
            public void updateProp(Component c, boolean hardValidate) {
                NewPolyPanel.this.closePoly();
            }
        });
        this.d_cancelPolyBtn = this.initButton(new JButton(Intl.intl("Cancel Polygon")), new IPropEditCommand(){

            @Override
            public void updateProp(Component c, boolean hardValidate) {
                ((PolyBuilder)NewPolyPanel.this.props()).cancel();
            }
        });
        JPanel fldsPanel = new JPanel(new GridBagLayout());
        GridBagUtil.add(fldsPanel, new guiLabel(Intl.intl("X:")), 0, 0, 1, 1, 0, 0, 3, 3, 0, 0.0, 0.0, 17);
        GridBagUtil.add(fldsPanel, this.d_x, 1, 0, 1, 1, 0, 0, 3, 3, 0, 0.0, 0.0, 17);
        GridBagUtil.add(fldsPanel, new guiLabel(Intl.intl("Y:")), 0, 1, 1, 1, 0, 0, 3, 3, 0, 0.0, 0.0, 17);
        GridBagUtil.add(fldsPanel, this.d_y, 1, 1, 1, 1, 0, 0, 0, 3, 0, 0.0, 0.0, 17);
        JPanel btnsPanel = new JPanel(new GridBagLayout());
        GridBagUtil.add(btnsPanel, this.d_addPointBtn, 0, 0, 1, 1, 0, 0, 3, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(btnsPanel, this.d_closePolyBtn, 0, 1, 1, 1, 0, 0, 3, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(btnsPanel, this.d_cancelPolyBtn, 0, 2, 1, 1, 0, 0, 0, 0, 2, 1.0, 0.0, 17);
        JPanel locPanel = new JPanel(new GridBagLayout());
        GridBagUtil.add(locPanel, fldsPanel, 0, 0, 1, 1, 0, 0, 0, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(locPanel, btnsPanel, 1, 0, 1, 1, 0, 0, 0, 0, 2, 1.0, 0.0, 17);
        this.addSection(locPanel);
    }

    @Override
    public void setProps(PolyBuilder props) {
        super.setProps(props);
        this.updateClosePolyCtrls();
        this.updateCancelPolyCtrls();
    }

    @Override
    public void update(Observable o, Object arg) {
        super.update(o, arg);
        if (this.aPropChanged(PolyBuilder.POINT_ADDED, PolyBuilder.COMPLETED, PolyBuilder.CANCELLED, PolyBuilder.POINT_REMOVED)) {
            this.updateClosePolyCtrls();
            this.updateCancelPolyCtrls();
        }
    }

    private void addPoint() {
        if (!this.validateData(true, true)) {
            return;
        }
        UnitDouble x = (UnitDouble)this.d_x.getValue();
        UnitDouble y = (UnitDouble)this.d_y.getValue();
        double xm = UnitDouble.convert(x.getValueNoUnit(), x.getUnit(), Geometry.LENGTH_UNIT);
        double ym = UnitDouble.convert(y.getValueNoUnit(), y.getUnit(), Geometry.LENGTH_UNIT);
        ((PolyBuilder)this.props()).addPoint(new Point2d(xm, ym));
    }

    private void closePoly() {
        if (!this.validateData(true, true)) {
            return;
        }
        ((PolyBuilder)this.props()).closePoly(this);
    }

    private void updateClosePolyCtrls() {
        if (this.d_closePolyBtn != null) {
            this.d_closePolyBtn.setEnabled(((PolyBuilder)this.props()).canClosePoly());
        }
    }

    private void updateCancelPolyCtrls() {
        if (this.d_cancelPolyBtn != null) {
            this.d_cancelPolyBtn.setEnabled(((PolyBuilder)this.props()).canCancelPoly());
        }
    }

    private class AddPtAction
    extends AbstractAction {
        private static final long serialVersionUID = 4447401100172527050L;

        private AddPtAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AddPtCmd cmd = new AddPtCmd();
            cmd.updateProp(NewPolyPanel.this, true);
        }
    }

    private class AddPtCmd
    implements IPropEditCommand {
        private AddPtCmd() {
        }

        @Override
        public void updateProp(Component c, boolean hardValidate) {
            NewPolyPanel.this.addPoint();
        }
    }
}

