/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiUnitDoubleField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.DoubleVR;
import ventus.Intl;
import ventus.VentusApp;
import ventus.builders.FloorExtractor3D;
import ventus.data.ImportedGeom;
import ventus.data.VentusData;
import ventus.geom.Geometry;
import ventus.geom.PointGeomFinder;
import ventus.gui.APropEditPanel;
import ventus.gui.IPropEditCommand;
import ventus.gui.MerlinUDF;
import ventus.mv.gui.LocationPanel;

public class FloorExtractor3DPanel
extends APropEditPanel<FloorExtractor3D> {
    private static final long serialVersionUID = 6149943644843713312L;
    private final LocationPanel<FloorExtractor3D> d_locPanel = new LocationPanel<FloorExtractor3D>(6, new Object[]{FloorExtractor3D.PICK_POINT_CHANGED}){
        private static final long serialVersionUID = -1339860838336975815L;

        @Override
        protected void updateFromProps(FloorExtractor3D props) {
            this.setValue(props.getPickPoint());
        }

        @Override
        protected void updateToProps(FloorExtractor3D props) {
            UnitPoint3D loc = this.getValue();
            VentusData md = VentusApp.getApp().getData();
            PointGeomFinder<ImportedGeom> finder = new PointGeomFinder<ImportedGeom>(loc.getPoint3dValue(Geometry.LENGTH_UNIT), 1.0E-6, ImportedGeom.class, o -> !o.isIgnoredInModelGeneration());
            md.geomLocation.getLocator().find(finder.test, finder.result, 0);
            ImportedGeom pickGeom = !finder.getResults().isEmpty() ? finder.getResults().keySet().iterator().next() : null;
            props.setPickPoint(loc, pickGeom);
        }
    };
    private final PropPanel d_propPanel = new PropPanel();
    private final ExtractPanel d_extractPnl = new ExtractPanel();

    public FloorExtractor3DPanel() {
        super(new Object[0]);
        this.addSection(this.d_locPanel);
        this.addSeparator();
        this.addSection(this.d_propPanel);
        this.addSeparator();
        this.addSection(this.d_extractPnl);
    }

    private static class PropPanel
    extends APropEditPanel<FloorExtractor3D> {
        private static final long serialVersionUID = 318855505691654682L;
        private final guiUnitDoubleField d_maxSlopeFld = this.initValueField(new MerlinUDF(NonSI.DEGREE_ANGLE, DoubleVR.between(0.0, 90.0, true, false)), true, new IPropEditCommand[0]);
        private final guiUnitDoubleField d_maxHeadHeight = this.initValueField(new MerlinUDF((Unit)SI.METER, DoubleVR.above(0.0, true)), true, new IPropEditCommand[0]);
        private final guiUnitDoubleField d_gapTolerance = this.initValueField(new MerlinUDF(4, DoubleVR.above(0.0, true)), true, new IPropEditCommand[0]);

        public PropPanel() {
            super(FloorExtractor3D.GAP_TOLERANCE, FloorExtractor3D.HEAD_HEIGHT_CHANGED, FloorExtractor3D.SLOPE_CHANGED);
            guiLabel slopeLbl = new guiLabel(Intl.intl("Max Slope: "));
            slopeLbl.setToolTipText(Intl.intl("Maximum traversable slope of 3D geometry."));
            guiLabel heightLbl = new guiLabel(Intl.intl("Max Head Height:"));
            heightLbl.setToolTipText(Intl.intl("Height at which to cut obstructions from the floor."));
            guiLabel gapLbl = new guiLabel(Intl.intl("Gap Tolerance:"));
            gapLbl.setToolTipText(Intl.intl("Minimum width of allowable gaps between walls (gaps smaller than this size are closed)."));
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(slopeLbl, this.d_maxSlopeFld);
            gb.addRow(heightLbl, this.d_maxHeadHeight);
            gb.addRow(gapLbl, this.d_gapTolerance);
        }

        @Override
        protected void updateToProps(FloorExtractor3D props) {
            props.pause();
            props.setMaxHeadHeight((UnitDouble)this.d_maxHeadHeight.getValue());
            props.setMaxSlope((UnitDouble)this.d_maxSlopeFld.getValue());
            props.setGapTolerance((UnitDouble)this.d_gapTolerance.getValue());
            props.resume();
        }

        @Override
        protected void updateFromProps(FloorExtractor3D props) {
            this.d_maxSlopeFld.setValue(props.getMaxSlope());
            this.d_maxHeadHeight.setValue(props.getMaxHeadHeight());
            this.d_gapTolerance.setValue(props.getGapTolerance());
        }
    }

    private static class ExtractPanel
    extends APropEditPanel<FloorExtractor3D> {
        private static final long serialVersionUID = 8615370238776193857L;
        private final JButton d_extractBtn = this.initButton(new JButton(Intl.intl("Extract")), new IPropEditCommand[0]);

        public ExtractPanel() {
            super(FloorExtractor3D.PICK_POINT_CHANGED);
            this.d_extractBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((FloorExtractor3D)this.props()).extractFloor(d_extractBtn);
                }
            });
            this.add(this.d_extractBtn);
        }

        @Override
        protected void updateFromProps(FloorExtractor3D props) {
            this.d_extractBtn.setEnabled(props.canExtractFloor());
        }
    }
}

