/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.displays;

import java.awt.Color;
import java.awt.Shape;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.objs.ShapeGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.text.IDisplayableTextSrc;
import ventus.builders.PlanarGeomBuilder;
import ventus.data.ImportedGeom;
import ventus.geom.Geometry;
import ventus.geom.IMerlinGeomSrc;
import ventus.mv.ModelView;
import ventus.mv.displays.APropsDisplay;

public class PlanarGeomBuilderDisplay
extends APropsDisplay<PlanarGeomBuilder> {
    private PlanarGeomBuilder d_props;

    public PlanarGeomBuilderDisplay(ModelView mv) {
        super(mv);
    }

    @Override
    protected Object[] getInterestingChanges() {
        return new Object[0];
    }

    @Override
    protected IMerlinGeomSrc constructGeom(PlanarGeomBuilder builder) {
        Shape outline = builder.getShape();
        if (outline == null) {
            return null;
        }
        ShapeGeom geom = new ShapeGeom(outline, this.getPlane(builder));
        IPrimProps.Edge props = new IPrimProps.Edge(this.getColor(), 3.0, IPrimProps.DEF_STIPPLE, 0);
        return new ImportedGeom("", new DisplayGeom((IGeomNode)GeomNodeUtil.newNode(geom), (IPrimProps)props));
    }

    @Override
    protected IDisplayableTextSrc constructText(PlanarGeomBuilder builder) {
        return builder.getLabelTextSrc(this.getModelView().getLengthUnits()[1], this.getColor());
    }

    protected Shape getOutline(PlanarGeomBuilder builder) {
        return builder.getShape();
    }

    protected Plane3d getPlane(PlanarGeomBuilder builder) {
        double z = builder.getZLoc().getValue(Geometry.LENGTH_UNIT);
        return new Plane3d(0.0, 0.0, 1.0, -z);
    }

    protected Color getColor() {
        return Color.GREEN;
    }

    @Override
    public void setProps(PlanarGeomBuilder props) {
        this.d_props = props;
        super.setProps(props);
    }
}

