/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.displays;

import java.awt.Color;
import java.util.function.Function;
import javax.vecmath.Point3d;
import thunderheadeng.scene3d.nativebuffered.IDisplayable;
import thunderheadeng.scene3d.nativebuffered.StringRenderer;
import ventus.MerlinPrefs;
import ventus.VentusApp;
import ventus.data.INamed;
import ventus.geom.IMerlinGeomSrc;
import ventus.mv.MerlinColors;
import ventus.mv.displays.IMerlinDisplay;
import ventus.mv.displays.LabelDispMgr;

public class NameDisplay
extends StringRenderer
implements IMerlinDisplay {
    private final IMerlinGeomSrc d_geomSrc;
    private final Function<IMerlinGeomSrc, LabelDispMgr.Label3DInfo> d_lblInfoGetter;

    public NameDisplay(IMerlinGeomSrc geomSrc, Function<IMerlinGeomSrc, LabelDispMgr.Label3DInfo> calcLblInfo) {
        this.d_geomSrc = geomSrc;
        this.d_lblInfoGetter = calcLblInfo;
        this.update();
    }

    @Override
    public void setSelected(boolean selected) {
        if (selected) {
            this.setColor(Color.YELLOW);
        } else {
            this.updateColor();
        }
    }

    @Override
    public void update() {
        assert (this.d_geomSrc instanceof INamed);
        this.setString(((INamed)((Object)this.d_geomSrc)).getName());
        this.updateColor();
        LabelDispMgr.Label3DInfo lblInfo = this.d_lblInfoGetter.apply(this.d_geomSrc);
        Point3d pt = this.d_geomSrc.getBounds().getCenter();
        pt.add(lblInfo.offset());
        this.setLocation(pt);
        this.setAnchor(lblInfo.anchor());
    }

    private void updateColor() {
        Color c;
        VentusApp app = VentusApp.getApp();
        if (MerlinPrefs.get(MerlinPrefs.LABEL_AUTO_COLOR).booleanValue()) {
            c = app.getModelView().getColors().getColor(MerlinColors.AXIS_TEXT_COLOR);
        } else {
            Color rgb = MerlinPrefs.get(MerlinPrefs.LABEL_CUSTOM_COLOR);
            c = new Color(rgb.getRed(), rgb.getGreen(), rgb.getBlue(), MerlinPrefs.get(MerlinPrefs.LABEL_ALPHA));
        }
        c = new Color(c.getRed(), c.getGreen(), c.getBlue(), MerlinPrefs.get(MerlinPrefs.LABEL_ALPHA));
        this.setColor(c);
    }

    @Override
    public IDisplayable[] getDisplayObjs() {
        return new IDisplayable[]{this};
    }
}

