/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.displays;

import java.util.function.Function;
import javax.vecmath.Point3d;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.nativebuffered.TextRenderer;
import thunderheadeng.util.Events;
import ventus.MerlinPrefs;
import ventus.actions.AMerlinBoolAction;
import ventus.data.VentusData;
import ventus.geom.IMerlinGeomSrc;
import ventus.mv.ModelView;
import ventus.mv.displays.AMerlinDispMgr;
import ventus.mv.displays.NameDisplay;
import ventus.mv.displays.scenefinders.DefSceneProvider;

public class LabelDispMgr<T extends IMerlinGeomSrc>
extends AMerlinDispMgr<T, NameDisplay> {
    private final TextRenderer d_tr = new TextRenderer();
    private final Function<IMerlinGeomSrc, Label3DInfo> d_lblInfoGetter;

    public LabelDispMgr(VentusData data, ModelView mv, Class<T> type, ModelScene scene) {
        this(data, mv, type, scene, null);
    }

    public LabelDispMgr(VentusData data, ModelView mv, Class<T> type, ModelScene scene, Function<IMerlinGeomSrc, Label3DInfo> calcLblInfo) {
        super(data, type, new DefSceneProvider(scene));
        this.d_tr.setFontSize(MerlinPrefs.get(MerlinPrefs.LABEL_FONT_SIZE).intValue());
        this.d_tr.setPadding(new int[]{10, 10, 10, 10});
        this.d_lblInfoGetter = calcLblInfo == null ? this::defaultLabelInfo : calcLblInfo;
    }

    @Override
    protected NameDisplay createDisplay(T obj, boolean visible, boolean selected) {
        NameDisplay rend = new NameDisplay((IMerlinGeomSrc)obj, this.d_lblInfoGetter);
        rend.setRenderer(this.d_tr);
        rend.setVisible(visible);
        rend.setSelected(selected);
        return rend;
    }

    @Override
    public void update(Events events) {
        super.update(events);
        this.d_tr.setFontSize(MerlinPrefs.get(MerlinPrefs.LABEL_FONT_SIZE).intValue());
    }

    private Label3DInfo defaultLabelInfo(IMerlinGeomSrc obj) {
        return new Label3DInfo(new Point3d(0.0, 0.0, 0.0), new Point3d(0.0, 0.0, 0.0));
    }

    public record Label3DInfo(Point3d offset, Point3d anchor) {
    }

    public static class ToggleLabelsAction
    extends AMerlinBoolAction {
        private static final long serialVersionUID = 1L;
        ModelView d_mv;

        public ToggleLabelsAction(ModelView mv, String desc, String lbl, boolean initValue) {
            super(lbl, initValue, null);
            this.putValue("ShortDescription", desc);
            this.d_mv = mv;
        }

        @Override
        protected void work(VentusData data, boolean selected) {
            this.d_mv.getDisplayManager().labelScenes.forEach(i -> i.scene.setVisible(selected));
            this.d_mv.repaint();
        }
    }
}

