/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.displays;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.scene3d.IDisplayMgr;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.transformpreview.EmptyTransformPreview;
import thunderheadeng.scene3d.transformpreview.ITransformPreview;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.LinkedIdentityHashMap;
import ventus.data.VentusData;
import ventus.data.schematics.Floor;
import ventus.data.schematics.FloorComposite;
import ventus.mv.displays.IMerlinDispMgr;
import ventus.util.MerlinUtil;

public class FloorDispMgr
implements IMerlinDispMgr<Floor> {
    private final VentusData d_data;
    private final Collection<ModelScene> d_importScenes;
    private final Map<Floor, ConvexHull> d_floorCRMap = new LinkedIdentityHashMap<Floor, ConvexHull>();

    public FloorDispMgr(VentusData data, Collection<ModelScene> importScenes) {
        this.d_data = data;
        this.d_importScenes = importScenes;
        this.addFloorClipRegions(this.getAllFloors());
    }

    private Collection<Floor> getAllFloors() {
        return this.d_data.floors.getMembers(Floor.class);
    }

    @Override
    public Predicate<Floor> getFilter() {
        return Filters.acceptAll();
    }

    @Override
    public Class<Floor> getType() {
        return Floor.class;
    }

    @Override
    public void getScenes(Consumer<ModelScene> scenes) {
    }

    @Override
    public void getScenes(Floor obj, Consumer<ModelScene> scenes) {
    }

    @Override
    public void update(Events events) {
        IEventRecord<Floor> floorEvts = events.getEvents(Floor.class, new Class[0]);
        Predicate<Object> genericChangeTest = Filters.accept(FloorComposite.ACTIVE_FLOOR).or(MerlinUtil::isVisibilityEvent).negate();
        if (floorEvts.hasAddedObjs() || floorEvts.hasRemovedObjs() || floorEvts.anyChangesMatch(genericChangeTest)) {
            this.updateAll();
        } else {
            this.updateClipVisibility(floorEvts.filterChanges(MerlinUtil::isVisibilityEvent));
        }
    }

    @Override
    public void updateVisibility(Collection<? extends Floor> objs) {
    }

    @Override
    public void updateAll() {
        this.removeFloorClipRegions(new ArrayList<Floor>(this.d_floorCRMap.keySet()));
        this.addFloorClipRegions(this.getAllFloors());
        this.updateClipVisibility(this.getAllFloors());
    }

    private void addFloorClipRegions(Collection<? extends Floor> floorsSet) {
        Floor[] floors = floorsSet.toArray(new Floor[floorsSet.size()]);
        ConvexHull[] hulls = this.d_data.floors.getClippingRegions(floors);
        for (int m = 0; m < floors.length; ++m) {
            this.d_floorCRMap.put(floors[m], hulls[m]);
        }
        this.updateClipVisibility(floorsSet);
    }

    private void removeFloorClipRegions(Collection<? extends Floor> floors) {
        for (Floor floor : floors) {
            ConvexHull ch = this.d_floorCRMap.remove(floor);
            if (ch == null) continue;
            this.removeCullBox(ch);
        }
    }

    private void updateClipVisibility(Collection<? extends Floor> floors) {
        for (Floor floor : floors) {
            ConvexHull ch = this.d_floorCRMap.get(floor);
            if (ch == null) continue;
            if (floor.isVisible()) {
                this.addCullBox(ch);
                continue;
            }
            this.removeCullBox(ch);
        }
        boolean anyVis = false;
        for (Floor floor : this.d_data.floors.getMembers(Floor.class)) {
            if (!floor.isVisible()) continue;
            anyVis = true;
            break;
        }
        if (!anyVis) {
            this.addCullBox(ConvexHull.ACCEPT_NONE);
        } else {
            this.removeCullBox(ConvexHull.ACCEPT_NONE);
        }
    }

    private void addCullBox(ConvexHull ch) {
        for (ModelScene ms : this.d_importScenes) {
            ms.addCullBox(ch);
        }
    }

    private void removeCullBox(ConvexHull ch) {
        for (ModelScene ms : this.d_importScenes) {
            ms.removeCullBox(ch);
        }
    }

    @Override
    public ITransformPreview getTransformPreview(IDisplayMgr<? super Floor> copyMgr, Collection<? extends Floor> objs, boolean copyMode) {
        return EmptyTransformPreview.INSTANCE;
    }

    @Override
    public void removeAll() {
    }

    @Override
    public void addDisplays(Collection<? extends Floor> objs) {
    }

    @Override
    public void updateDisplays(Collection<? extends Floor> objs) {
    }

    @Override
    public void removeDisplays(Collection<? extends Floor> objs) {
    }

    @Override
    public void removeFromScene(Collection<? extends Floor> obj) {
    }

    @Override
    public void addToScene(Collection<? extends Floor> obj) {
    }
}

