/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv;

import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import thunderheadeng.gui.guiStatusMessage;
import thunderheadeng.gui.tool.Tool;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.util.IFilteredCollection;
import ventus.VentusApp;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.feature.comps.ItemStatusInfoProvider;

public class VentusToolStatusMessage
extends guiStatusMessage {
    private static final long serialVersionUID = 1L;
    private String d_toolMessage = null;
    private Optional<String> d_modelMessage = Optional.empty();
    private Tool d_currentTool = null;

    @Override
    public void setMessage(String message) {
        this.d_toolMessage = message;
        this.update();
    }

    public void updateModelInfoMessage(VentusData data, Tool t) {
        if (VentusApp.getAppOpt().isEmpty()) {
            this.clearAndUpdate();
            return;
        }
        this.d_currentTool = t;
        IFilteredCollection<IMerlinObj> objs = data.selection.flatten(IMerlinObj.class);
        HashMap<Object, String> info = new HashMap<Object, String>();
        Collection<ItemStatusInfoProvider> providers = VentusApp.getApp().getComponents(ItemStatusInfoProvider.class);
        for (ItemStatusInfoProvider provider : providers) {
            info.putAll(provider.getInfo(data, objs));
        }
        String name = (String)info.get(ItemStatusInfoProvider.NAME);
        String results = (String)info.get(ItemStatusInfoProvider.RESULTS);
        if (StringUtils.isEmpty(results)) {
            this.clearAndUpdate();
            return;
        }
        String fullMsg = Stream.of(name, results).filter(obj -> !StringUtils.isEmpty(obj)).collect(Collectors.joining("; "));
        if (StringUtils.isEmpty(fullMsg)) {
            this.clearAndUpdate();
            return;
        }
        this.d_modelMessage = Optional.of(fullMsg);
        this.update();
    }

    private void clearAndUpdate() {
        this.d_modelMessage = Optional.empty();
        this.update();
    }

    private void update() {
        CursorTool ct;
        Tool tool;
        if (this.d_currentTool != null && (tool = this.d_currentTool) instanceof CursorTool && (ct = (CursorTool)tool).getFunction().getStatusMessageAllowOverride(ct)) {
            super.setMessage(this.d_modelMessage.orElse(this.d_toolMessage));
        } else {
            super.setMessage(this.d_toolMessage);
        }
    }
}

