/*
 * Decompiled with CFR 0.152.
 */
package ventus.manip;

import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.manip.ATransformManip;
import ventus.mv.ModelView;
import ventus.mv.displays.GlobalDisplayMgr;

public class MirrorManip
extends ATransformManip {
    private Plane3d d_mirrorPlane = null;

    public MirrorManip(ModelView mv, GlobalDisplayMgr dispMgr, GlobalDisplayMgr xformDispMgr) {
        super(mv, dispMgr, xformDispMgr);
    }

    public void setPlane(Plane3d plane) {
        if (!this.lock()) {
            return;
        }
        this.d_mirrorPlane = plane;
        if (this.d_mirrorPlane == null || !MirrorManip.isValid(this.d_mirrorPlane)) {
            this.modify(i -> TransformUtil.IDENTITY);
        } else {
            Plane3d tplane = this.d_mirrorPlane.normalize();
            this.modify(i -> TransformUtil.mirror(tplane));
        }
        this.release();
    }

    private static boolean isValid(Plane3d plane) {
        return !theUtil.eq0(plane.x, 1.0E-12) || !theUtil.eq0(plane.y, 1.0E-12) || !theUtil.eq0(plane.z, 1.0E-12);
    }

    public Plane3d getPlane() {
        return this.d_mirrorPlane;
    }

    @Override
    protected void reset() {
        this.d_mirrorPlane = null;
    }

    @Override
    protected String getActionName() {
        return Intl.intl("Mirror");
    }
}

