/*
 * Decompiled with CFR 0.152.
 */
package ventus.gui.stat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BooleanSupplier;
import java.util.function.IntPredicate;
import java.util.function.Supplier;
import thunderheadeng.gui.value.AValEditor;
import thunderheadeng.gui.value.IValEditor;
import thunderheadeng.gui.value.MultiValEditor;
import thunderheadeng.gui.value.PopupValEditor;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.IDistributedVal;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.LogNormCurve;
import thunderheadeng.util.stat.StdNormCurve;
import thunderheadeng.util.stat.UniformCurve;
import ventus.Intl;
import ventus.data.stat.CurveUtil;
import ventus.gui.stat.ConstantEditor;
import ventus.gui.stat.DiscreteCurveEditor;
import ventus.gui.stat.LogNormEditor;
import ventus.gui.stat.NormEditor;
import ventus.gui.stat.UniformEditor;
import ventus.gui.stat.guiCurveUtil;
import ventus.unitsystem.SIUS;

public class VerboseDistributedValEditor
extends MultiValEditor<IDistributedVal<UnitDouble>> {
    private static final long serialVersionUID = -2729712180348926416L;
    public static final int OPT_CONSTANT = 1;
    public static final int OPT_UNIFORM = 2;
    public static final int OPT_NORM = 4;
    public static final int OPT_LOGNORM = 8;
    public static final int OPT_DISCRETE = 16;
    public static final int OPT_ALL = 31;

    public static Collection<MultiValEditor.Entry<IDistributedVal<UnitDouble>, ? extends IDistributedVal<UnitDouble>>> getEntries(int unit, int options, boolean inline, UnitDoubleVR range) {
        AValEditor discreteEditor;
        AValEditor logNormEditor;
        AValEditor uniformEditor;
        AValEditor NormEditor2;
        ArrayList<MultiValEditor.Entry<IDistributedVal<UnitDouble>, ? extends IDistributedVal<UnitDouble>>> entries = new ArrayList<MultiValEditor.Entry<IDistributedVal<UnitDouble>, ? extends IDistributedVal<UnitDouble>>>();
        IntPredicate opt = i -> (i & options) == i;
        ConstantEditor constEditor = new ConstantEditor(unit, range);
        if (opt.test(1)) {
            entries.add(new MultiValEditor.Entry<IDistributedVal, ConstantCurve>(Intl.intl("Constant"), Intl.intl("Enter a constant value."), constEditor, curve -> curve != null, () -> true, curve -> CurveUtil.toConstantCurve(curve, unit)));
        }
        BooleanSupplier NormFunc = () -> true;
        BooleanSupplier uniformFunc = () -> true;
        BooleanSupplier logNormFunc = () -> true;
        BooleanSupplier discreteFunc = () -> true;
        if (inline) {
            NormEditor2 = new NormEditor(unit, range);
            uniformEditor = new UniformEditor(unit, range);
            logNormEditor = new LogNormEditor(unit, range);
            discreteEditor = new DiscreteCurveEditor(unit);
        } else {
            DlgCurveEditor<StdNormCurve> dlgStdNormEditor = new DlgCurveEditor<StdNormCurve>(StdNormCurve.class, () -> new NormEditor(unit, range), Intl.intl("Normal Distribution"));
            DlgCurveEditor<UniformCurve> dlgUniformEditor = new DlgCurveEditor<UniformCurve>(UniformCurve.class, () -> new UniformEditor(unit, range), Intl.intl("Uniform Distribution"));
            DlgCurveEditor<LogNormCurve> dlgLogNormEditor = new DlgCurveEditor<LogNormCurve>(LogNormCurve.class, () -> new LogNormEditor(unit, range), Intl.intl("Log Normal Distribution"));
            DlgCurveEditor<IUrn> dlgDiscreteCurveEditor = new DlgCurveEditor<IUrn>(IUrn.class, () -> new DiscreteCurveEditor(unit), Intl.intl("Discrete Distribution"));
            NormFunc = () -> dlgStdNormEditor.editValue();
            uniformFunc = () -> dlgUniformEditor.editValue();
            logNormFunc = () -> dlgLogNormEditor.editValue();
            discreteFunc = () -> dlgDiscreteCurveEditor.editValue();
            NormEditor2 = dlgStdNormEditor;
            uniformEditor = dlgUniformEditor;
            logNormEditor = dlgLogNormEditor;
            discreteEditor = dlgDiscreteCurveEditor;
        }
        if (opt.test(2)) {
            entries.add(new MultiValEditor.Entry<IDistributedVal, UniformCurve>(Intl.intl("Uniform"), Intl.intl("Enter a uniform distribution."), uniformEditor, curve -> curve != null, uniformFunc, curve -> CurveUtil.toUniformCurve(curve, unit)));
        }
        if (opt.test(4)) {
            entries.add(new MultiValEditor.Entry<IDistributedVal, StdNormCurve>(Intl.intl("Normal"), Intl.intl("Enter a normal distribution."), NormEditor2, curve -> curve != null, NormFunc, curve -> CurveUtil.toStdNormCurve(curve, unit)));
        }
        if (opt.test(8)) {
            entries.add(new MultiValEditor.Entry<IDistributedVal, LogNormCurve>(Intl.intl("Log-normal"), Intl.intl("Enter a log normal distribution."), logNormEditor, curve -> curve != null, logNormFunc, curve -> CurveUtil.toLogNormCurve(curve, unit)));
        }
        if (opt.test(16)) {
            entries.add(new MultiValEditor.Entry<IDistributedVal, IUrn>(Intl.intl("Discrete"), Intl.intl("Enter a discrete distribution."), discreteEditor, curve -> curve != null, discreteFunc, curve -> CurveUtil.toDiscreteCurve(curve, unit)));
        }
        return entries;
    }

    public VerboseDistributedValEditor(int unit, boolean inline) {
        this(unit, inline, UnitDoubleVR.above(0.0, SIUS.unit(unit), true));
    }

    public VerboseDistributedValEditor(int unit, boolean inline, UnitDoubleVR range) {
        this(unit, inline, 31, range);
    }

    public VerboseDistributedValEditor(int unit, boolean inline, int options) {
        this(unit, inline, options, UnitDoubleVR.above(0.0, SIUS.unit(unit), true));
    }

    public VerboseDistributedValEditor(int unit, boolean inline, int options, UnitDoubleVR range) {
        super(IDistributedVal.class, VerboseDistributedValEditor.getEntries(unit, options, inline, range), false);
    }

    private static class DlgCurveEditor<T extends IDistributedVal<UnitDouble>>
    extends PopupValEditor<T> {
        private static final long serialVersionUID = 1104839981710285898L;

        public DlgCurveEditor(Class<T> type, Supplier<? extends IValEditor<T>> editor, String desc) {
            super(PopupValEditor.Mode.BUTTON, type, desc, editor, curve -> guiCurveUtil.format(curve));
        }
    }
}

