/*
 * Decompiled with CFR 0.152.
 */
package ventus.gui;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JComponent;
import thunderheadeng.gui.dialogs.AFindDlg;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.util.Filters;
import ventus.EntryPointFactory;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.Composite;
import ventus.data.IMerlinObj;
import ventus.data.INamed;
import ventus.data.NamedMerlinObj;
import ventus.data.VentusData;
import ventus.geom.IMerlinGeomSrc;

public class VentusFindDialog
extends AFindDlg<INamed, VentusData> {
    private static final long serialVersionUID = 1L;
    private guiCheckBox d_objectNames;
    private guiCheckBox d_objectTags;

    public VentusFindDialog(Window owner, VentusData md) {
        super(owner, md);
    }

    @Override
    protected Collection<JComponent> getSubclassComponents() {
        if (this.d_objectNames == null) {
            this.d_objectNames = new guiCheckBox(Intl.intl("Object Names"));
            this.d_objectNames.setToolTipText(Intl.intl("Includes the names of objects in the search."));
            this.d_objectNames.setSelected(true);
        }
        if (this.d_objectTags == null) {
            this.d_objectTags = new guiCheckBox(Intl.intl("Object Tags"));
            this.d_objectTags.setToolTipText(Intl.intl("Includes an object's tags in the search."));
            this.d_objectTags.setSelected(true);
        }
        return List.of(this.d_objectNames, this.d_objectTags);
    }

    @Override
    public void perform(final guiComboBox<String> findComboBox, final guiLabel messageLabel, final AFindDlg.ActionAfterQuery action) {
        UIHook.run((Component)this, "Find", new AMerlinOp(){

            @Override
            public void run(VentusApp app, VentusData md) {
                VentusFindDialog.this.run(findComboBox, messageLabel, action);
            }
        }, 0);
    }

    @Override
    protected Collection<INamed> find(String query) {
        if (query.trim().isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList<Object> objects = new ArrayList<Object>();
        VentusData md = (VentusData)this.getDomain();
        for (Object child : EntryPointFactory.get(md).tvEntryPoint.getChildren(md, md)) {
            if (child instanceof INamed) {
                objects.add((INamed)child);
            }
            if (!(child instanceof Composite)) continue;
            objects.addAll(((Composite)child).getDeepMembers());
        }
        if (query.toLowerCase().startsWith("numtris")) {
            return objects.stream().filter(VentusFindDialog.getNumTrisFilter(query)).collect(Collectors.toList());
        }
        Function<INamed, Stream> getSearchStrings = this.d_objectNames.isSelected() && this.d_objectTags.isSelected() ? o -> {
            IMerlinObj celem;
            Stream<String> strings = Stream.of(o.getName());
            if (o instanceof IMerlinObj && (celem = (IMerlinObj)((Object)o)).getSupportedProps(IMerlinObj.SupportMode.LOCAL_ONLY).contains(VentusData.TAGS)) {
                strings = Stream.concat(strings, celem.getWithDetails(VentusData.TAGS).stream().flatMap(tags -> tags.stream()).map(NamedMerlinObj::getName));
            }
            return strings;
        } : (this.d_objectNames.isSelected() ? o -> Stream.of(o.getName()) : (this.d_objectTags.isSelected() ? o -> {
            IMerlinObj celem;
            if (o instanceof IMerlinObj && (celem = (IMerlinObj)((Object)o)).getSupportedProps(IMerlinObj.SupportMode.LOCAL_ONLY).contains(VentusData.TAGS)) {
                return celem.getWithDetails(VentusData.TAGS).stream().flatMap(tags -> tags.stream()).map(NamedMerlinObj::getName);
            }
            return Stream.empty();
        } : o -> Stream.empty()));
        return this.performSearch(query, objects, getSearchStrings);
    }

    @Override
    protected void selectNext() {
        if (!this.getIterator().hasNext()) {
            return;
        }
        try (VentusData.WriteLock lock = ((VentusData)this.getDomain()).lockWrite();){
            Undo.begin(Intl.intl("Find Next"));
            Undo.insertUndoEntry_restoreSelection((VentusData)this.getDomain());
            ((VentusData)this.getDomain()).selection.set(this.getIterator().next());
            Undo.end((VentusData)this.getDomain());
        }
        VentusFindDialog.showSelectionInTree();
    }

    @Override
    protected void selectAll() {
        try (VentusData.WriteLock lock = ((VentusData)this.getDomain()).lockWrite();){
            Undo.begin(Intl.intl("Find All"));
            Undo.insertUndoEntry_restoreSelection((VentusData)this.getDomain());
            ((VentusData)this.getDomain()).selection.set(this.getSelection());
            Undo.end((VentusData)this.getDomain());
        }
        VentusFindDialog.showSelectionInTree();
    }

    private static Predicate<INamed> getNumTrisFilter(String query) {
        int count;
        IntPredicate comparator;
        if (!query.toLowerCase().startsWith("numtris")) {
            return Filters.rejectAll();
        }
        StringTokenizer toks = new StringTokenizer(query, " ");
        if (toks.countTokens() != 3) {
            return Filters.rejectAll();
        }
        toks.nextToken();
        String compStr = toks.nextToken();
        String numStr = toks.nextToken();
        switch (compStr) {
            case ">": {
                comparator = i -> i > 0;
                break;
            }
            case ">=": {
                comparator = i -> i >= 0;
                break;
            }
            case "<": {
                comparator = i -> i < 0;
                break;
            }
            case "<=": {
                comparator = i -> i <= 0;
                break;
            }
            case "==": {
                comparator = i -> i == 0;
                break;
            }
            default: {
                return Filters.rejectAll();
            }
        }
        try {
            count = Integer.parseInt(numStr.trim());
        }
        catch (Throwable t) {
            return Filters.rejectAll();
        }
        return elem -> {
            if (!(elem instanceof IMerlinGeomSrc)) {
                return false;
            }
            IMerlinGeomSrc geom = (IMerlinGeomSrc)((Object)elem);
            int numPrims = geom.getGeom().getNumPrims(1);
            return comparator.test(numPrims - count);
        };
    }

    private static void showSelectionInTree() {
        EventQueue.invokeLater(() -> {
            VentusApp app = VentusApp.getApp();
            if (app != null) {
                app.getTreeView().showCurrentSelection();
            }
        });
    }
}

