/*
 * Decompiled with CFR 0.152.
 */
package ventus.gui;

import javax.swing.JComponent;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.guiUnitDoubleField;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.WeakHashSet;
import ventus.VentusApp;
import ventus.data.VentusData;
import ventus.unitsystem.UnitSystem;
import ventus.unitsystem.UnitUpdatableComponent;

public class UnitUpdator
implements IEventObserver {
    private static final WeakHashSet<JComponent> s_comps = new WeakHashSet();
    private static final UnitUpdator s_instance = new UnitUpdator();

    public static void addComp(JComponent comp) {
        s_comps.add(comp);
        UnitUpdator.update(comp);
    }

    public static void removeComp(JComponent comp) {
        s_comps.remove(comp);
    }

    public UnitUpdator() {
        VentusApp.getApp().getData().getEvents().addObserver(this);
    }

    @Override
    public void update(Events events) {
        for (EventChannel<VentusData> channel : events.getAffectedChannels(VentusData.class, new Class[0])) {
            if (!channel.hasChangedObjs(VentusData.UNITSYSTEM_CHANGED)) continue;
            for (JComponent comp : s_comps) {
                UnitUpdator.update(comp);
            }
        }
    }

    private static void update(JComponent comp) {
        if (comp instanceof guiUnitDoubleField) {
            UnitUpdator.update((guiUnitDoubleField)comp);
        } else if (comp instanceof UnitUpdatableComponent) {
            UnitUpdator.update((UnitUpdatableComponent)((Object)comp));
        }
    }

    private static void update(UnitUpdatableComponent editor) {
        UnitSystem currus = VentusApp.getApp().getUnitSystem();
        Unit newu = currus.getUnit(UnitSystem.getType(editor.getDisplayUnit()));
        editor.update(newu);
    }

    public static void update(guiUnitDoubleField field) {
        Unit u = field.getDisplayUnit();
        int type = UnitSystem.getType(u);
        if (type == -1) {
            System.err.println("Couldn't find unit type for " + String.valueOf(u));
            return;
        }
        UnitSystem currus = VentusApp.getApp().getUnitSystem();
        Unit newu = currus.getUnit(type);
        field.setDisplayUnit(newu);
    }
}

