/*
 * Decompiled with CFR 0.152.
 */
package ventus.gui;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javafx.stage.FileChooser;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiIntField;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.TeciProps;
import ventus.Intl;
import ventus.MerlinPrefs;
import ventus.VentusApp;
import ventus.mv.ModelView;

public class SnapshotDialog
extends guiDialog {
    private static final long serialVersionUID = 8572283065869303522L;
    private final ModelView d_mv;
    private final JRadioButton d_snapshotButton;
    private final JRadioButton d_povrayButton;
    private final JCheckBox d_antiAlias;
    private final JCheckBox d_shadows;
    private final JCheckBox d_povFile;
    private final TitleSeparator d_exportTypeTitle;
    private final List<FileChooser.ExtensionFilter> d_fileFilterList;
    private final guiPanel d_dlgPanel;
    private final guiTextField d_filenameField;
    private final JButton d_filenameButton;
    private final guiIntField d_widthField;
    private final guiIntField d_heightField;
    private final JButton d_useWindowSizeButton;
    private FileChooser.ExtensionFilter d_filterJpeg;
    private final FileChooser.ExtensionFilter d_filterPng;
    private final FileChooser.ExtensionFilter d_filterBmp;
    private FileChooser.ExtensionFilter d_filterTiff;
    private final FileChooser.ExtensionFilter d_filterTarga;
    private final FileChooser.ExtensionFilter d_filterGif;
    private final FileChooser.ExtensionFilter d_filterPpm;

    public SnapshotDialog(JFrame owner, ModelView mv) {
        super((Window)owner, Intl.intl("Snapshot Properties"), 9);
        this.d_mv = mv;
        this.d_dlgPanel = super.getDialogPane();
        this.d_dlgPanel.setLayout(new GridBagLayout());
        this.d_filenameField = new guiTextField("");
        this.d_filenameButton = new JButton(Intl.intl("Browse") + "...");
        this.d_snapshotButton = new JRadioButton(Intl.intl("PyroSim"));
        this.d_povrayButton = new JRadioButton(Intl.intl("POV-Ray"));
        this.d_antiAlias = new JCheckBox(Intl.intl("Anti-alias"));
        this.d_shadows = new JCheckBox(Intl.intl("Shadows"));
        this.d_povFile = new JCheckBox(Intl.intl("Export POV File"));
        this.d_exportTypeTitle = new TitleSeparator(Intl.intl("Render Program"));
        this.d_fileFilterList = new ArrayList<FileChooser.ExtensionFilter>();
        this.d_widthField = new guiIntField();
        this.d_heightField = new guiIntField();
        this.d_useWindowSizeButton = new JButton(Intl.intl("Use window size"));
        this.d_filterJpeg = new FileChooser.ExtensionFilter("JPEG", "*.jpg");
        this.d_filterPng = new FileChooser.ExtensionFilter("PNG", "*.png");
        this.d_filterBmp = new FileChooser.ExtensionFilter("BMP", "*.bmp");
        this.d_filterTiff = new FileChooser.ExtensionFilter("TIFF", "*.tif");
        this.d_filterTarga = new FileChooser.ExtensionFilter("TARGA", "*.tga", "*.targa");
        this.d_filterGif = new FileChooser.ExtensionFilter("GIF", "*.gif");
        this.d_filterPpm = new FileChooser.ExtensionFilter("PPM", "*.ppm");
        this.setInitialProperties();
        this.d_filenameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File currentFile = new File(SnapshotDialog.this.d_filenameField.getText());
                guiJFXFileChooser chooser = new guiJFXFileChooser(currentFile.getName(), currentFile.getAbsolutePath(), null, (Boolean)true, (Boolean)true, (Boolean)false, SnapshotDialog.this.d_fileFilterList);
                File f = chooser.showSaveDialog();
                if (f == null) {
                    return;
                }
                String file = f.getAbsolutePath();
                SnapshotDialog.this.d_filenameField.setText(file);
                SnapshotDialog.this.d_filenameField.setToolTipText(file);
            }
        });
        this.buildPanel();
    }

    @Override
    public int doModal() {
        int result = super.doModal();
        if (result == 1) {
            VentusApp.getApp().beginWaitCursor();
            if (this.d_snapshotButton.isSelected()) {
                this.takeShot();
            } else {
                this.runPOV();
            }
            VentusApp.getApp().endWaitCursor();
        }
        return result;
    }

    private void buildPanel() {
        guiLabel filenameL = new guiLabel(Intl.intl("File") + ":");
        guiLabel sizeL = new guiLabel(Intl.intl("Size") + ":");
        guiLabel pyroSimL = new guiLabel(Intl.intl("(fast, medium quality)"));
        guiLabel povrayL = new guiLabel(Intl.intl("(slow, high quality)"));
        guiLabel x = new guiLabel("x");
        guiPanel filenamePanel = new guiPanel(new GridBagLayout());
        int row = 0;
        GridBagUtil.add(filenamePanel, filenameL, 0, row, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(filenamePanel, this.d_filenameField, 1, row, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(filenamePanel, this.d_filenameButton, 2, row, 1, 1, 0, 0, 0, 0, 0, 0.0, 0.0, 17);
        guiPanel sizePanel = new guiPanel(new GridBagLayout());
        row = 0;
        GridBagUtil.add(sizePanel, sizeL, 0, ++row, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(sizePanel, this.d_widthField, 1, row, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(sizePanel, x, 2, row, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(sizePanel, this.d_heightField, 3, row, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(sizePanel, this.d_useWindowSizeButton, 4, row, 1, 1, 0, 0, 0, 0, 0, 0.0, 0.0, 17);
        guiPanel progPanel = new guiPanel(new GridBagLayout());
        row = 0;
        GridBagUtil.add(progPanel, this.d_exportTypeTitle, 0, row, 2, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(progPanel, this.d_snapshotButton, 0, ++row, 1, 1, 0, 12, 2, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(progPanel, pyroSimL, 1, row, 1, 1, 0, 6, 2, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(progPanel, this.d_povrayButton, 0, ++row, 1, 1, 0, 12, 2, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(progPanel, povrayL, 1, row, 1, 1, 0, 6, 2, 0, 0, 0.0, 0.0, 17);
        guiPanel povPanel = new guiPanel(new GridBagLayout());
        row = 0;
        GridBagUtil.add(povPanel, this.d_antiAlias, 0, row, 1, 1, 0, 24, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(povPanel, this.d_shadows, 1, row, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(povPanel, this.d_povFile, 2, row, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        row = 0;
        GridBagUtil.add(this.d_dlgPanel, filenamePanel, 0, ++row, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this.d_dlgPanel, sizePanel, 0, ++row, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
    }

    private void setInitialProperties() {
        VentusApp app = VentusApp.getApp();
        Dimension d = this.d_filenameField.getPreferredSize();
        int height = d.height;
        this.d_filenameField.setPreferredSize(new Dimension(200, height));
        this.d_filenameField.setEditable(false);
        String f = MerlinPrefs.get(MerlinPrefs.OPEN_DIR_PREF);
        String absFile = app.getPrefs().getString(MerlinPrefs.LastScreenShotAbsoluteProp);
        if (!absFile.equals("")) {
            this.d_filenameField.setText(absFile);
        } else if (f != null) {
            this.d_filenameField.setText(f + "\\snapshot.png");
        } else {
            f = Application.getApp().getInstallDir();
            this.d_filenameField.setText(f + "\\snapshot.png");
        }
        this.d_filenameField.setToolTipText(this.d_filenameField.getText());
        if (app.getPrefs().getBoolean(MerlinPrefs.LastScreenShotPyroButton)) {
            Dimension maxSize = this.d_mv.getScreenshotGenerator().getMaximumSize();
            this.d_widthField.setValueRange(IntVR.between(1, maxSize.width, true, true));
            this.d_heightField.setValueRange(IntVR.between(1, maxSize.height, true, true));
        } else {
            this.d_widthField.setValueRange(IntVR.between(1, 5000000, true, true));
            this.d_heightField.setValueRange(IntVR.between(1, 5000000, true, true));
        }
        this.d_widthField.setColumns(5);
        this.d_heightField.setColumns(5);
        this.fillSizeFromView();
        int ssWidth = app.getPrefs().getInt(MerlinPrefs.LastScreenShotWidth);
        int ssHeight = app.getPrefs().getInt(MerlinPrefs.LastScreenShotHeight);
        this.d_widthField.setValue(ssWidth);
        this.d_heightField.setValue(ssHeight);
        this.d_useWindowSizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SnapshotDialog.this.fillSizeFromView();
            }
        });
        boolean pyroButton = app.getPrefs().getBoolean(MerlinPrefs.LastScreenShotPyroButton);
        this.d_snapshotButton.setSelected(pyroButton);
        this.d_povrayButton.setSelected(!pyroButton);
        this.d_antiAlias.setSelected(app.getPrefs().getBoolean(MerlinPrefs.POVScreenShotAntiAlias));
        this.d_antiAlias.setEnabled(!pyroButton);
        this.d_shadows.setSelected(app.getPrefs().getBoolean(MerlinPrefs.POVScreenShotShadows));
        this.d_shadows.setEnabled(!pyroButton);
        this.d_povFile.setSelected(app.getPrefs().getBoolean(MerlinPrefs.POVScreenShotPOVFile));
        this.d_povFile.setEnabled(!pyroButton);
        if (pyroButton) {
            this.d_filterJpeg = new FileChooser.ExtensionFilter("JPEG", "*.jpg", "*.jif", "*.jpeg", "*.jpe");
            this.d_filterTiff = new FileChooser.ExtensionFilter("TIFF", "*.tif", "*.tiff");
            this.d_fileFilterList.add(this.d_filterBmp);
            this.d_fileFilterList.add(this.d_filterJpeg);
            this.d_fileFilterList.add(this.d_filterTiff);
        } else {
            this.d_fileFilterList.remove(this.d_filterPpm);
        }
        this.d_fileFilterList.add(this.d_filterPng);
        this.d_fileFilterList.add(this.d_filterTarga);
        ButtonGroup group = new ButtonGroup();
        group.add(this.d_snapshotButton);
        group.add(this.d_povrayButton);
        this.d_snapshotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SnapshotDialog.this.d_antiAlias.setEnabled(false);
                SnapshotDialog.this.d_shadows.setEnabled(false);
                SnapshotDialog.this.d_povFile.setEnabled(false);
                Dimension maxSize = SnapshotDialog.this.d_mv.getScreenshotGenerator().getMaximumSize();
                SnapshotDialog.this.d_widthField.setValueRange(IntVR.between(1, maxSize.width, true, true));
                SnapshotDialog.this.d_heightField.setValueRange(IntVR.between(1, maxSize.height, true, true));
                if (SnapshotDialog.this.d_filenameField.getText().endsWith(".ppm")) {
                    SnapshotDialog.this.d_filenameField.setText(SnapshotDialog.this.d_filenameField.getText().replace(".ppm", ".png"));
                }
            }
        });
    }

    private void fillSizeFromView() {
        this.d_widthField.setValue(this.d_mv.getRenderComp().getWidth());
        this.d_heightField.setValue(this.d_mv.getRenderComp().getHeight());
    }

    private void runPOV() {
    }

    private boolean takeShot() {
        String file = this.d_filenameField.getText();
        int dotIndex = file.lastIndexOf(".");
        if (dotIndex < 0) {
            JOptionPane.showMessageDialog(this.d_dlgPanel, "Enter a file name.", "Error", 0);
            return false;
        }
        this.d_mv.getScreenshotGenerator().setSize((Integer)this.d_widthField.getValue(), (Integer)this.d_heightField.getValue());
        this.d_mv.getScreenshotGenerator().writeFile(file);
        VentusApp app = VentusApp.getApp();
        TeciProps prefs = app.getPrefs();
        MerlinPrefs.set(MerlinPrefs.OPEN_DIR_PREF, new File(file).getAbsolutePath());
        prefs.set(MerlinPrefs.LastScreenShotAbsoluteProp, file);
        prefs.set(MerlinPrefs.LastScreenShotWidth, (Integer)this.d_widthField.getValue());
        prefs.set(MerlinPrefs.LastScreenShotHeight, (Integer)this.d_heightField.getValue());
        prefs.set(MerlinPrefs.LastScreenShotPyroButton, Boolean.valueOf(true));
        this.d_mv.getRenderComp().repaint();
        return true;
    }
}

