/*
 * Decompiled with CFR 0.152.
 */
package ventus.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.PrintStream;
import java.util.List;
import java.util.Vector;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.text.AttributeSet;
import thunderheadeng.gui.guiDialog;
import ventus.Intl;
import ventus.gui.ScrollingConsole;

public class RunSimDlg
extends guiDialog {
    private static final long serialVersionUID = 8942847620837494893L;
    public static final int SIM_PRE = 0;
    public static final int SIM_RUNNING = 1;
    public static final int SIM_PAUSED = 2;
    public static final int SIM_COMPLETE = 3;
    private static final String STR_OK = Intl.intl("OK");
    private static final String STR_CANCEL = Intl.intl("Cancel");
    private static final String STR_LOG = Intl.intl("Save Log...");
    private final JButton d_btOK;
    private final JButton d_btSaveLog;
    private final ScrollingConsole d_log;
    private final List<DlgListener> d_listeners;
    private int d_state = -1;

    public RunSimDlg(JFrame parent) {
        super((Window)parent, Intl.intl("Run Simulation"), 1);
        this.setResizable(true);
        this.d_btOK = this.getButton(1);
        this.d_btOK.setText(STR_OK);
        this.d_btSaveLog = new JButton(STR_LOG);
        JComponent[] buttons = new JButton[]{this.d_btSaveLog, this.d_btOK};
        this.setButtons(buttons);
        this.d_log = new ScrollingConsole();
        this.d_log.setPreferredSize(new Dimension(550, 450));
        this.getDialogPane().setLayout(new BorderLayout());
        this.getDialogPane().add((Component)this.d_log, "Center");
        this.d_listeners = new Vector<DlgListener>();
        this.connectToEvent(this.d_btOK, new EventOK());
        this.connectToEvent(this.d_btSaveLog, new EventLog());
    }

    public void setTitleFromPath(String vntFilePath) {
        this.setTitle(String.format(Intl.intl("Run Simulation - %s"), RunSimDlg.getName(vntFilePath)));
    }

    private static String getName(String filename) {
        return new File(filename).getName();
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible && this.isVisible() && !this.okCancel()) {
            return;
        }
        super.setVisible(visible);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean okCancel() {
        if (this.d_btOK.getText().equals(STR_OK)) {
            this.fireEvent(new EventOK());
            return true;
        }
        if (!this.d_btOK.getText().equals(STR_CANCEL)) {
            assert (false);
            return true;
        }
        String msg = Intl.intl("Are you sure you would like to cancel?\nSimulation progress will be lost.");
        int choice = JOptionPane.showConfirmDialog(this, msg, Intl.intl("Cancel"), 0);
        if (choice == 0) {
            this.fireEvent(new EventCancel());
            return true;
        }
        if (choice == 1) return false;
        return true;
    }

    private void connectToEvent(JButton bt, final EventOp op) {
        bt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunSimDlg.this.fireEvent(op);
            }
        });
    }

    public void setState(int state) {
        if (state == this.d_state) {
            return;
        }
        this.d_state = state;
        switch (state) {
            case 0: 
            case 1: 
            case 2: {
                this.d_btOK.setText(STR_CANCEL);
                break;
            }
            case 3: {
                this.d_btOK.setText(STR_OK);
            }
        }
    }

    public void printToLog(String str) {
        this.d_log.addLine(str);
    }

    public void printToWarn(String str) {
        this.d_log.addWarning(str);
    }

    public Handler createLogHandler() {
        return new Handler(){

            @Override
            public void publish(LogRecord record) {
                if (record.getLevel().intValue() < this.getLevel().intValue()) {
                    return;
                }
                AttributeSet style = record.getLevel().intValue() >= Level.WARNING.intValue() ? ScrollingConsole.STYLE_WARN : ScrollingConsole.STYLE_DEFAULT;
                RunSimDlg.this.d_log.addLine(style, record.getMessage());
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        };
    }

    public void writeLogText(PrintStream ps) {
        this.d_log.writeText(ps);
    }

    private void fireEvent(EventOp op) {
        for (DlgListener dl : this.d_listeners) {
            op.fire(dl);
        }
    }

    public void deleteListener(DlgListener listener) {
        this.d_listeners.remove(listener);
    }

    public void addListener(DlgListener listener) {
        this.d_listeners.add(listener);
    }

    private class EventOK
    implements EventOp {
        private EventOK() {
        }

        @Override
        public void fire(DlgListener dl) {
            dl.actionOK(RunSimDlg.this);
        }
    }

    private static interface EventOp {
        public void fire(DlgListener var1);
    }

    private class EventLog
    implements EventOp {
        private EventLog() {
        }

        @Override
        public void fire(DlgListener dl) {
            dl.actionLog(RunSimDlg.this);
        }
    }

    private class EventCancel
    implements EventOp {
        private EventCancel() {
        }

        @Override
        public void fire(DlgListener dl) {
            dl.actionCancel(RunSimDlg.this);
        }
    }

    public static interface DlgListener {
        public void actionOK(RunSimDlg var1);

        public void actionCancel(RunSimDlg var1);

        public void actionStop(RunSimDlg var1);

        public void actionLog(RunSimDlg var1);
    }

    private class EventStop
    implements EventOp {
        private EventStop() {
        }

        @Override
        public void fire(DlgListener listener) {
            listener.actionStop(RunSimDlg.this);
        }
    }
}

