/*
 * Decompiled with CFR 0.152.
 */
package ventus.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import org.jscience.physics.units.NonSI;
import thunderheadeng.gui.CrashCatcher;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.dialogs.CustomKeyAcceleratorDlg;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiJFXDirectoryChooser;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.scene3d.gui.GPUInfoPnl;
import thunderheadeng.scene3d.gui.RenderPrefs;
import thunderheadeng.scene3d.gui.ToolPrefsPnl;
import thunderheadeng.scene3d.nativebuffered.IRenderSurface;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.TeciProps;
import thunderheadeng.util.TypedProp;
import ventus.Intl;
import ventus.MerlinPrefs;
import ventus.VentusApp;
import ventus.actions.MerlinActionMap;
import ventus.actions.Undo;
import ventus.data.VentusData;
import ventus.data.schematics.geom.SchematicRoom;
import ventus.gui.guiUtil;

public class PreferencesDlg
extends guiDialog {
    private static final long serialVersionUID = 3687627459355463425L;
    private final guiCheckBox d_crashCatcherNag;
    private final guiCheckBox d_autosaveCB;
    private final guiCheckBox d_listEditorsPromptToSaveCB;
    private final ValueField<UnitDouble> d_autosaveIntervalFld;
    private final guiCheckBox d_backupCB;
    private final guiCheckBox d_customBackupDirCB;
    private final guiTextField d_customBackupDirTF;
    private final JButton d_customBackupDirButton;
    private final ValueField<Double> d_displayEdgeError;
    private final ValueField<Double> d_displayFaceError;
    private final guiCheckBox d_labelAutoColorCB;
    private final ColorButton d_labelColorButton;
    private final ValueField<UnitDouble> d_opacityFld;
    private final guiComboBox<Integer> d_labelSize;
    private final RenderPrefs.PrefsUI d_rprefs;
    private final JTabbedPane d_tabs;
    private final Map<Tabs, Integer> d_tabMap = new HashMap<Tabs, Integer>();
    private final guiCheckBox d_meshOptimization;
    private final ValueField<Integer> d_maxUndoHistory;
    private final ToolPrefsPnl d_toolPrefs;

    public PreferencesDlg(JFrame owner, MerlinActionMap hotkeys, Supplier<IRenderSurface.OpenGLInfo> getRenderInfo, RenderPrefs.Profiles renderProfiles) {
        super((Window)owner, Intl.intl("Preferences"), 9);
        this.d_crashCatcherNag = new guiCheckBox(Intl.intl("Always Prompt for Additional Info on Crash"));
        this.d_listEditorsPromptToSaveCB = new guiCheckBox(Intl.intl("List Editors Prompt to Save"));
        this.d_rprefs = new RenderPrefs.PrefsUI("Ventus");
        this.d_autosaveCB = new guiCheckBox(Intl.intl("Autosave:"));
        this.d_autosaveIntervalFld = ValueFields.udFld(10.0, DoubleVR.above(0.0, false), NonSI.MINUTE);
        LinkStatus.link((AbstractButton)this.d_autosaveCB, this.d_autosaveIntervalFld);
        this.d_backupCB = new guiCheckBox(Intl.intl("Create Backup on Open"));
        this.d_customBackupDirCB = new guiCheckBox(Intl.intl("Custom Backup Directory:"));
        this.d_customBackupDirTF = new guiTextField();
        this.d_customBackupDirTF.setEditable(false);
        this.d_customBackupDirTF.setPreferredSize(new Dimension(100, this.d_customBackupDirTF.getPreferredSize().height));
        this.d_customBackupDirButton = new JButton("Edit...");
        this.d_customBackupDirButton.addActionListener(evt -> this.showCustomDirChooser());
        LinkStatus.link((AbstractButton)this.d_customBackupDirCB, this.d_customBackupDirTF, this.d_customBackupDirButton);
        this.d_displayEdgeError = ValueFields.doubleFld(DoubleVR.above(0.0, false));
        this.d_displayFaceError = ValueFields.doubleFld(DoubleVR.above(0.0, false));
        guiLabel edgeErrorLbl = new guiLabel(Intl.intl("Curve error:"));
        edgeErrorLbl.setToolTipText(Intl.intl("Sets the amount of error when displaying curved CAD lines."));
        guiLabel faceErrorLbl = new guiLabel(Intl.intl("Face error:"));
        faceErrorLbl.setToolTipText(Intl.intl("Sets the amount of error when displaying curved CAD faces."));
        this.d_labelAutoColorCB = new guiCheckBox(Intl.intl("Match Label Color to Color Scheme"));
        this.d_labelColorButton = guiUtil.newColorButton();
        this.d_opacityFld = ValueFields.udFld(100.0, DoubleVR.between(0.0, 100.0, true, true), NonSI.PERCENT);
        this.d_labelSize = new guiComboBox<Integer>(new Integer[]{8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 32, 36, 40}){

            @Override
            public boolean validateData(boolean showWarn, boolean allowModify) {
                super.validateData(showWarn, allowModify);
                try {
                    int n = Integer.parseInt(String.valueOf(this.getSelectedItem()));
                }
                catch (Exception e) {
                    if (showWarn) {
                        String msg = String.format(Intl.intl("Invalid font size."), new Object[0]);
                        this.showMessageBox(msg);
                        this.requestFocusHack();
                        this.setSelectedItem(0);
                        this.setSelectedItem(null);
                    }
                    return false;
                }
                return true;
            }
        };
        this.d_labelSize.setEditable(true);
        this.d_labelAutoColorCB.setToolTipText(Intl.intl("When checked, label color is automatically determined by the current color scheme."));
        guiLabel lblLabelColorButton = new guiLabel(Intl.intl("Custom Color:"));
        lblLabelColorButton.setToolTipText(Intl.intl("Sets the color of text labels for objects in the model view."));
        guiLabel lblOpacity = new guiLabel(Intl.intl("Label Opacity:"));
        lblOpacity.setToolTipText(Intl.intl("Sets the opacity of text labels for objects in the model view"));
        guiLabel lblLabelSize = new guiLabel(Intl.intl("Label Font Size:"));
        lblLabelSize.setToolTipText(Intl.intl("Sets the font size of text labels for objects in the model view."));
        LinkStatus.link((AbstractButton)this.d_labelAutoColorCB, true, lblLabelColorButton, this.d_labelColorButton);
        this.d_meshOptimization = new guiCheckBox(Intl.intl("Optimize Zone Geometry"));
        guiLabel hotkeyLbl = new guiLabel(Intl.intl("Keyboard Shortcuts:"));
        JButton editHotkeys = new JButton(Intl.intl("Edit..."));
        editHotkeys.addActionListener(e -> {
            CustomKeyAcceleratorDlg dlg = new CustomKeyAcceleratorDlg(owner, hotkeys.getUiHelper());
            if (dlg.doModal() == 1) {
                dlg.saveData();
            }
        });
        guiLabel undoHistoryLabel = guiUtil.lbl(Intl.intl("Undo/Redo History:"), "<html>" + Intl.intl("Sets the maximum number of actions to remember for <b>Undo</b> and <b>Redo</b>."));
        this.d_maxUndoHistory = ValueFields.intFld(IntVR.between(0, 200, false, true));
        this.d_toolPrefs = new ToolPrefsPnl();
        this.d_tabs = new JTabbedPane();
        BiConsumer<Tabs, guiPanel> addTab = (tab, pnl) -> {
            int ix = this.d_tabs.getTabCount();
            this.d_tabs.addTab(tab.desc, (Component)pnl);
            this.d_tabMap.put((Tabs)((Object)tab), ix);
        };
        guiPanel generalPnl = new guiPanel();
        GridBagHelper gb = new GridBagHelper(generalPnl, true);
        gb.addFilledRow(new TitleSeparator(Intl.intl("General")));
        gb.indent();
        gb.addRow(hotkeyLbl, editHotkeys);
        gb.addRow(undoHistoryLabel, this.d_maxUndoHistory);
        gb.addRow(this.d_listEditorsPromptToSaveCB, 0);
        gb.unindent();
        gb.addFilledRow(new TitleSeparator(Intl.intl("File Backup")));
        gb.indent();
        gb.addRow(this.d_autosaveCB, this.d_autosaveIntervalFld, 0);
        gb.addRow(this.d_backupCB, 0);
        gb.addRow(this.d_customBackupDirCB, this.d_customBackupDirTF, this.d_customBackupDirButton);
        gb.unindent();
        gb.addFilledRow(new TitleSeparator(Intl.intl("Reporting")));
        gb.indent();
        gb.addRow(this.d_crashCatcherNag, 0);
        gb.unindent();
        gb.addFilledRow(new TitleSeparator(Intl.intl("Display")));
        gb.indent();
        gb.addRow(edgeErrorLbl, this.d_displayEdgeError, 0);
        gb.addRow(faceErrorLbl, this.d_displayFaceError, 0);
        gb.unindent();
        gb.addFilledRow(new TitleSeparator(Intl.intl("Object Labels")));
        gb.indent();
        gb.addRow(this.d_labelAutoColorCB, 0);
        gb.indent();
        gb.addRow(lblLabelColorButton, this.d_labelColorButton, 0);
        gb.unindent();
        gb.addRow(lblOpacity, this.d_opacityFld, 0);
        gb.addRow(lblLabelSize, this.d_labelSize, 0);
        gb.unindent();
        gb.addFilledRow(new TitleSeparator(Intl.intl("Zone Geometry")));
        gb.indent();
        gb.addRow(this.d_meshOptimization, 0);
        gb.unindent();
        gb.addFilledRow(this.d_toolPrefs);
        gb.finalizeRows();
        addTab.accept(Tabs.GENERAL, generalPnl);
        guiPanel renderingPnl = new guiPanel();
        gb = new GridBagHelper(renderingPnl, true);
        gb.addTitle(Intl.intl("GPU Information"));
        gb.indent();
        gb.addFilledRow(new GPUInfoPnl(getRenderInfo, true));
        gb.unindent();
        gb.addSeparator();
        guiPanel rendPrefBtns = RenderPrefs.getRenderPrefsBtns(renderProfiles, props -> this.loadRenderPrefs((IPropertySet)props, true, false));
        gb.addRow(new Object[]{rendPrefBtns, 1.0, 0, GridBagHelper.Anchor.CENTER});
        this.d_rprefs.addTo(gb);
        gb.finalizeRows();
        addTab.accept(Tabs.RENDERING, renderingPnl);
        this.getDialogPane().add(this.d_tabs);
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        return this.d_rprefs.validateData(showWarn, allowModify);
    }

    public void setTab(Tabs tab) {
        this.d_tabs.setSelectedIndex(this.d_tabMap.get((Object)tab));
    }

    public void init(VentusApp app) {
        this.loadPrefs(app);
        this.loadRenderPrefs(MerlinPrefs.instance(), false, true);
        this.setModified(false);
    }

    private void loadPrefs(VentusApp app) {
        this.d_crashCatcherNag.setSelected(MerlinPrefs.getBoolean(CrashCatcher.PROP_INFO_NAG));
        this.d_listEditorsPromptToSaveCB.setSelected(MerlinPrefs.getBoolean(MerlinPrefs.LIST_EDITORS_PROMPT_TO_SAVE));
        this.d_autosaveCB.setSelected(MerlinPrefs.getBoolean(MerlinPrefs.BACKUP_AUTOSAVE));
        this.d_autosaveIntervalFld.setValue(MerlinPrefs.getUnitDouble(MerlinPrefs.BACKUP_AUTOSAVE_INTERVAL, NonSI.MINUTE));
        this.d_backupCB.setSelected(MerlinPrefs.getBoolean(MerlinPrefs.BACKUP_BACKUPONOPEN));
        this.d_customBackupDirCB.setSelected(MerlinPrefs.getBoolean(MerlinPrefs.BACKUP_CUSTOMDIR));
        this.d_customBackupDirTF.setText(MerlinPrefs.getString(MerlinPrefs.BACKUP_CUSTOMDIR_PATH));
        this.d_customBackupDirTF.setToolTipText(MerlinPrefs.getString(MerlinPrefs.BACKUP_CUSTOMDIR_PATH));
        this.d_displayEdgeError.setValue(MerlinPrefs.getDouble(MerlinPrefs.DISPLAY_EDGE_ERROR));
        this.d_displayFaceError.setValue(MerlinPrefs.getDouble(MerlinPrefs.DISPLAY_FACE_ERROR));
        this.d_labelAutoColorCB.setSelected(MerlinPrefs.get(MerlinPrefs.LABEL_AUTO_COLOR));
        this.d_labelColorButton.setColor(MerlinPrefs.get(MerlinPrefs.LABEL_CUSTOM_COLOR));
        this.d_opacityFld.setValue(new UnitDouble(Math.round((double)MerlinPrefs.get(MerlinPrefs.LABEL_ALPHA).intValue() * 100.0 / 255.0), NonSI.PERCENT));
        this.d_labelSize.setSelectedItem(MerlinPrefs.getInt(MerlinPrefs.LABEL_FONT_SIZE));
        this.d_meshOptimization.setSelected(MerlinPrefs.get(MerlinPrefs.MESH_OPTIMIZATION));
        this.d_maxUndoHistory.setValue(MerlinPrefs.get(MerlinPrefs.UNDO_STACK_SIZE));
        this.d_toolPrefs.load(app.getPrefs());
    }

    private void loadRenderPrefs(IPropertySet props, boolean onlyIfDefined, boolean clearRestart) {
        this.d_rprefs.loadData(props, onlyIfDefined, clearRestart);
    }

    private static <T> void set(TypedProp<T> prop, T value) {
        VentusApp.setPref(prop, value);
    }

    public void commit(VentusApp app) {
        TeciProps tprops = new TeciProps();
        this.d_rprefs.saveData(tprops);
        PreferencesDlg.set(CrashCatcher.PROP_INFO_NAG, this.d_crashCatcherNag.isSelected());
        PreferencesDlg.set(MerlinPrefs.LIST_EDITORS_PROMPT_TO_SAVE, this.d_listEditorsPromptToSaveCB.isSelected());
        PreferencesDlg.set(MerlinPrefs.DISPLAY_EDGE_ERROR, (Double)this.d_displayEdgeError.getValue());
        PreferencesDlg.set(MerlinPrefs.DISPLAY_FACE_ERROR, (Double)this.d_displayFaceError.getValue());
        PreferencesDlg.set(MerlinPrefs.LABEL_AUTO_COLOR, this.d_labelAutoColorCB.isSelected());
        PreferencesDlg.set(MerlinPrefs.LABEL_CUSTOM_COLOR, this.d_labelColorButton.getColor());
        PreferencesDlg.set(MerlinPrefs.LABEL_ALPHA, (int)(((UnitDouble)this.d_opacityFld.getValue()).getRawValue() / 100.0 * 255.0));
        PreferencesDlg.set(MerlinPrefs.LABEL_FONT_SIZE, this.d_labelSize.getSelectedItem());
        PreferencesDlg.set(MerlinPrefs.BACKUP_AUTOSAVE, this.d_autosaveCB.isSelected());
        PreferencesDlg.set(MerlinPrefs.BACKUP_AUTOSAVE_INTERVAL, ((UnitDouble)this.d_autosaveIntervalFld.getValue()).get(NonSI.MINUTE));
        PreferencesDlg.set(MerlinPrefs.BACKUP_BACKUPONOPEN, this.d_backupCB.isSelected());
        PreferencesDlg.set(MerlinPrefs.BACKUP_CUSTOMDIR, this.d_customBackupDirCB.isSelected());
        if (this.d_customBackupDirCB.isSelected()) {
            PreferencesDlg.set(MerlinPrefs.BACKUP_CUSTOMDIR_PATH, this.d_customBackupDirTF.getText());
        }
        if (this.d_meshOptimization.isSelected() != MerlinPrefs.get(MerlinPrefs.MESH_OPTIMIZATION).booleanValue()) {
            PreferencesDlg.set(MerlinPrefs.MESH_OPTIMIZATION, this.d_meshOptimization.isSelected());
            if (this.d_meshOptimization.isSelected()) {
                this.optimizeMesh();
            }
        }
        PreferencesDlg.set(MerlinPrefs.UNDO_STACK_SIZE, (Integer)this.d_maxUndoHistory.getValue());
        this.d_toolPrefs.save(tprops);
        app.getModelView().getDisplayManager().updateAll();
        VentusApp.setPrefs(tprops);
    }

    private void optimizeMesh() {
        int reply = JOptionPane.showConfirmDialog(this, Intl.intl("Would you like to optimize all navigation geometry now?"), Intl.intl("Optimize navigation geometry?"), 0);
        if (reply == 0) {
            VentusData md = VentusApp.getApp().getData();
            Collection<SchematicRoom> rooms = md.floors.flatten(SchematicRoom.class);
            try (VentusData.WriteLock lock = md.lockWrite();){
                Undo.begin(Intl.intl("Optimize Geometry"));
                Undo.insertUndoEntry_restore(md, rooms);
                SchematicRoom.cleanup(md, rooms);
                Undo.end(md);
            }
        }
    }

    private void showCustomDirChooser() {
        String currentDir = this.d_customBackupDirTF.getText();
        String initialDir = MerlinPrefs.get(MerlinPrefs.BACKUP_CUSTOMDIR_PATH);
        guiJFXDirectoryChooser chooser = new guiJFXDirectoryChooser(currentDir != null ? currentDir : initialDir, null);
        File f = chooser.showDirDialog();
        if (f == null) {
            return;
        }
        this.d_customBackupDirTF.setText(f.getAbsolutePath());
        this.d_customBackupDirTF.setToolTipText(f.getAbsolutePath());
    }

    public static enum Tabs {
        GENERAL(Intl.intl("General")),
        RENDERING(Intl.intl("Rendering"));

        public final String desc;

        private Tabs(String desc) {
            this.desc = desc;
        }
    }
}

