/*
 * Decompiled with CFR 0.152.
 */
package ventus.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import thunderheadeng.gui.framework.ObjSource;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Predicates;
import ventus.EntryPointFactory;
import ventus.data.Composite;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.data.material.Material;
import ventus.data.schematics.Floor;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.feature.CompositeFeatureGuid;
import ventus.util.MerlinUtil;

public class ObjSources {
    public static <T extends IMerlinObj> ObjSource<T> fromModelRobust(VentusData data, Class<T> type, String nullName) {
        return ObjSources.fromModelRobust(data, type, nullName, Predicates.alwaysTrue());
    }

    public static <T extends IMerlinObj> ObjSource<T> fromModelRobust(VentusData data, Class<T> type, String nullName, Predicate<? super T> filter) {
        return ObjSources.fromModelRobust((VentusData)data, type, (String)nullName, filter, (T obj) -> 0, null, (IMerlinObj[])new IMerlinObj[0]);
    }

    public static <T extends IMerlinObj> ObjSource<T> fromModelRobust(VentusData vd, Class<T> type, String nullName, Predicate<? super T> filter, ToIntFunction<T> getFontStyle, Comparator<T> nonNullSorter, T ... specialValues) {
        Supplier<Stream> getBaseObjs = () -> {
            Stream<Object> stream = type.equals(Material.class) ? vd.materials.flatten(type, filter).stream() : vd.getChildren().stream().filter(member -> member instanceof Composite).map(member -> (Composite)member).flatMap(comp -> comp.flatten(type, filter).stream());
            if (nonNullSorter == null) {
                ArrayList values = stream.collect(Collectors.toCollection(() -> new ArrayList()));
                Comparator sort = MerlinUtil.getSorter(vd, values);
                Collections.sort(values, sort);
                return values.stream();
            }
            return stream.sorted(nonNullSorter);
        };
        Supplier<Stream> getObjs = () -> {
            Stream<Object> result = Stream.empty();
            if (nullName != null && Stream.of(specialValues).noneMatch(v -> v == null)) {
                result = Stream.of((IMerlinObj)null);
            }
            result = Stream.concat(result, Stream.of(specialValues));
            return Stream.concat(result, (Stream)getBaseObjs.get());
        };
        ObjSource.IFormat<IMerlinObj> baseFormatter = (obj, bc) -> {
            Composite<IMerlinObj> root;
            Composite<IMerlinObj> composite = root = obj != null ? EntryPointFactory.get(obj).getRootComposite(vd) : null;
            if (root != null) {
                return MerlinUtil.getName(root, obj, bc);
            }
            return MerlinUtil.getName(vd, obj, bc);
        };
        ObjSource.IFormat<IMerlinObj> format = nullName == null ? baseFormatter : (v, bc) -> v == null ? nullName : baseFormatter.apply((IMerlinObj)v, bc);
        return new ObjSource<IMerlinObj>(type, format, getFontStyle, getObjs, true);
    }

    public static <T extends IMerlinObj> ObjSource<T> fromRoot(VentusData vd, Composite<? extends IMerlinObj> root, Class<T> clazz, Predicate<? super T> availFilter) {
        return ObjSources.fromRoot(vd, root, clazz, availFilter, null);
    }

    public static <T extends IMerlinObj> ObjSource<T> fromRoot(VentusData vd, Composite<? extends IMerlinObj> root, Class<T> clazz, Predicate<? super T> availFilter, Comparator<T> sorter) {
        Predicate<Object> filter = availFilter == null ? Filters.acceptAll(clazz) : availFilter;
        return new ObjSource<IMerlinObj>(clazz, (obj, bc) -> MerlinUtil.getName(root, obj, bc), obj -> 0, () -> {
            Stream stream = root.flatten(clazz, filter).stream();
            if (sorter == null) {
                ArrayList objs = stream.collect(Collectors.toCollection(() -> new ArrayList()));
                Comparator sort = MerlinUtil.getSorter(vd, objs);
                Collections.sort(objs, sort);
                return objs.stream();
            }
            return stream.sorted(sorter);
        }, true);
    }

    public static ObjSource<Floor> getFloors(VentusData vd, String nullName) {
        return ObjSource.includeNull(Floor.class, nullName, (obj, bc) -> MerlinUtil.getName(vd.floors, obj, bc), obj -> 0, (f1, f2) -> f1.getWorkingZ().compareTo(f2.getWorkingZ()), () -> vd.floors.flatten(Floor.class).stream(), true);
    }

    public static ObjSource<ISchematicRoom> getZones(VentusData vd, String nullName) {
        return ObjSources.includeNull(ISchematicRoom.class, nullName, (obj, bc) -> MerlinUtil.getName(vd.floors, obj, bc), obj -> 0, () -> vd.floors.flatten(ISchematicRoom.class).stream());
    }

    public static ObjSource<Material> getMaterials(VentusData vd, String nullName) {
        return ObjSources.includeNull(Material.class, nullName, (obj, bc) -> MerlinUtil.getName(vd.materials, obj, bc), obj -> 0, () -> vd.materials.flatten(Material.class).stream());
    }

    public static <RootT extends Composite<ObjT>, ObjT extends IMerlinObj> ObjSource<ObjT> getFeature(VentusData vd, CompositeFeatureGuid<RootT, ObjT> guid, String nullName) {
        return ObjSources.includeNull(guid.objType, nullName, (obj, bc) -> MerlinUtil.getName(vd.getComponentData(guid), obj, bc), obj -> 0, () -> ((Composite)vd.getComponentData(guid)).flatten(guid.objType).stream());
    }

    public static <ObjT extends IMerlinObj> ObjSource<ObjT> includeNull(Class<ObjT> type, String nullName, ObjSource.IFormat<ObjT> nonNullFormat, ToIntFunction<ObjT> getFontStyle, Supplier<? extends Stream<? extends ObjT>> getNonNullObjs) {
        return ObjSource.includeNull(type, nullName, nonNullFormat, getFontStyle, MerlinUtil.sortByName(obj -> nonNullFormat.apply(obj, false)), getNonNullObjs, true);
    }
}

