/*
 * Decompiled with CFR 0.152.
 */
package ventus.gui;

import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.JFrame;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import ventus.Intl;
import ventus.data.Composite;
import ventus.data.VentusData;
import ventus.gui.NodeComboBox;
import ventus.gui.NodeComboModel;

public class NewGroupDlg<T extends Composite>
extends guiDialog {
    private static final long serialVersionUID = 8366577330919384316L;
    private final VentusData d_mediator;
    private final NodeComboBox<T> d_group;
    private final guiTextField d_newGroupFld;

    public NewGroupDlg(JFrame owner, VentusData md, final Collection<? extends T> roots, T initial, Class<T> type, final Predicate<? super T> filter, String defGroupName) {
        super((Window)owner, Intl.intl("Create Group Node"), 9);
        Set<T> selected;
        this.d_mediator = md;
        this.d_newGroupFld = new guiTextField(defGroupName);
        if (initial == null && !(selected = md.selection.getSelectedWithChildren(type)).isEmpty()) {
            initial = (Composite)selected.iterator().next();
        }
        NodeComboModel<T> model = new NodeComboModel<T>(this.d_mediator, type, new NodeComboModel.RootFinder<T>(){

            @Override
            public Collection<? extends T> getRoots(VentusData md) {
                return roots;
            }

            @Override
            public boolean includeRoot() {
                return true;
            }

            @Override
            public Predicate<? super T> getFilter(VentusData md) {
                return filter;
            }
        });
        this.d_group = new NodeComboBox<T>(model);
        this.d_group.addActionListener(e -> {
            Composite selected = (Composite)this.d_group.getSelectedNode();
            if (selected != null) {
                this.d_newGroupFld.setText(selected.getNewGroupName());
            }
        });
        if (initial != null) {
            this.d_group.setSelectedNode(initial);
            this.d_newGroupFld.setText(((Composite)initial).getNewGroupName());
        }
        guiPanel p = this.getDialogPane();
        p.setLayout(new GridBagLayout());
        int row = 0;
        GridBagUtil.add(p, new guiLabel(Intl.intl("Parent Group Node") + ":"), 0, row, 1, 1, 0, 0, 0, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(p, this.d_group, 1, row++, 1, 1, 0, 6, 0, 0, 1, 1.0, 1.0, 17);
        GridBagUtil.add(p, new guiLabel(Intl.intl("Group Node Name") + ":"), 0, row, 1, 1, 6, 0, 0, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(p, this.d_newGroupFld, 1, row, 1, 1, 6, 6, 0, 0, 1, 1.0, 1.0, 17);
    }

    public T getParentGroup() {
        return (T)((Composite)this.d_group.getSelectedNode());
    }

    public String getNewGroupName() {
        return this.d_newGroupFld.getText();
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        if (this.getNewGroupName().equals("")) {
            String msg = Intl.intl("Error: Please enter a name for the group node.");
            this.showMessageBox(msg);
            this.requestFocusHack();
            return false;
        }
        return true;
    }
}

