/*
 * Decompiled with CFR 0.152.
 */
package ventus.gui;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import thunderheadeng.gui.guiComboBox;
import ventus.data.VentusData;
import ventus.data.schematics.Floor;
import ventus.gui.FloorComboModel;
import ventus.gui.guiUtil;

public class FloorComboBox
extends guiComboBox<Floor> {
    private static final long serialVersionUID = 4406705108312643361L;
    private final VentusData d_data;

    public FloorComboBox(VentusData data) {
        this.d_data = data;
        this.setModel(new FloorComboModel(data));
        data.getEvents().addObserver((FloorComboModel)this.getModel());
        this.setRenderer(new CellRenderer());
        this.setMinimumSize(new Dimension(0, this.getMinimumSize().height));
        this.setEditor(new BasicComboBoxEditor(){

            @Override
            public void setItem(Object anObject) {
                if (anObject instanceof Floor) {
                    FloorComboBox.this.getModel().setSelectedItem(anObject);
                }
                super.setItem(anObject);
            }
        });
    }

    private class CellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 4247433228252040828L;

        private CellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == FloorComboModel.SEPARATOR) {
                return (JSeparator)value;
            }
            Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            guiUtil.decorateComboRenderer(FloorComboBox.this.d_data, FloorComboBox.this, list, value, this, isSelected, cellHasFocus);
            return c;
        }
    }
}

