/*
 * Decompiled with CFR 0.152.
 */
package ventus.gui;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.PropValue;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.data.Composite;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.gui.guiUtil;
import ventus.util.MerlinUtil;

public class DiscreteChooser<T extends IMerlinObj>
extends guiPanel
implements Modifiable,
IEventObserver {
    private static final long serialVersionUID = -6497902746136640855L;
    private boolean d_modified = false;
    private final List<Runnable> d_commitActions;
    private final VentusData d_data;
    private final String d_desc;
    private final JEditorPane d_editor;
    private List<T> d_availObjs;
    private PropValue<T> d_obj;
    private final Class<T> d_clazz;
    private final Predicate<? super T> d_filter;

    public DiscreteChooser(VentusData md, String desc, Class<T> clazz, Predicate<? super T> availFilter) {
        this.d_data = md;
        this.d_commitActions = new ArrayList<Runnable>();
        this.d_desc = desc;
        this.d_clazz = clazz;
        this.d_obj = PropValue.of(null);
        this.d_filter = availFilter == null ? Filters.acceptAll(clazz) : availFilter;
        this.d_editor = guiUtil.newHTMLLabel();
        this.d_editor.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && DiscreteChooser.this.d_editor.isEnabled()) {
                    DiscreteChooser.this.edit();
                }
            }
        });
        GridBagHelper gb = new GridBagHelper(this);
        gb.addRow(this.d_editor, 1.0);
        gb.finalizeRows();
        this.d_data.getEvents().addObserver(this);
        this.updateAvailable();
    }

    protected void edit() {
        Window parent = guiUtil.getWindow(this);
        DiscreteObjDlg<IMerlinObj> dlg = new DiscreteObjDlg<IMerlinObj>(parent, this.d_desc, this.d_data);
        dlg.setObjs(this.d_availObjs, this.d_obj.isUniform() ? (IMerlinObj)this.d_obj.get() : null);
        if (dlg.doModal() != 1) {
            return;
        }
        this.setObj(PropValue.of(dlg.getObj()));
        this.d_modified = true;
        this.d_commitActions.forEach(a -> a.run());
        this.getComm().touch(this);
    }

    @Override
    public void setModified(boolean modified) {
        this.d_modified = modified;
        super.setModified(modified);
    }

    @Override
    public boolean isModified() {
        return this.d_modified;
    }

    protected List<T> getAllAvailableObjs() {
        ArrayList<? super T> items = new ArrayList<T>();
        for (IMerlinObj iMerlinObj : this.d_data.getChildren()) {
            if (!(iMerlinObj instanceof Composite)) continue;
            items.addAll(theUtil.filter(((Composite)iMerlinObj).flatten(this.d_clazz), this.d_filter));
        }
        Collections.sort(items, (o1, o2) -> MerlinUtil.getName(o1).compareToIgnoreCase(MerlinUtil.getName(o2)));
        return items;
    }

    public void setObj(PropValue<T> obj) {
        this.d_obj = obj;
        this.updateDesc();
        this.d_modified = false;
    }

    public T getObj() {
        return (T)((IMerlinObj)this.d_obj.get());
    }

    public void addCommitAction(Runnable action) {
        this.d_commitActions.add(action);
    }

    protected void updateAvailable() {
        this.d_availObjs = this.getAllAvailableObjs();
        if (this.d_obj != null && this.d_obj.isUniform() && this.d_obj.get() != null && this.d_availObjs != null && !this.d_availObjs.contains(this.d_obj.get())) {
            this.d_obj = PropValue.of(null);
        }
        this.updateDesc();
    }

    @Override
    public void update(Events events) {
        if (events.isAffected(this.d_clazz)) {
            this.updateAvailable();
        }
    }

    protected void updateDesc() {
        boolean isShortened;
        String desc = null;
        desc = !this.d_obj.isUniform() ? Intl.intl("[mixed]") : (this.d_obj.get() == null ? Intl.intl("[none]") : MerlinUtil.getName((IMerlinObj)this.d_obj.get()));
        FontMetrics fm = this.d_editor.getFontMetrics(this.d_editor.getFont());
        Object displayDesc = guiUtil.shorten(desc, 100, fm);
        boolean bl = isShortened = !((String)displayDesc).equals(desc);
        if (!this.d_availObjs.isEmpty()) {
            displayDesc = "<html><a href=\"blank\">" + (String)displayDesc + "</a></html>";
        }
        this.d_editor.setText((String)displayDesc);
        if (isShortened) {
            this.d_editor.setToolTipText(desc);
        } else {
            this.d_editor.setToolTipText(null);
        }
    }

    private static class DiscreteObjDlg<T extends IMerlinObj>
    extends guiDialog {
        private static final long serialVersionUID = -1877884478905442942L;
        private final DefaultListModel<T> model = new DefaultListModel();
        private final JList<T> list = new JList<T>(this.model);

        public DiscreteObjDlg(Window parent, String desc, final VentusData md) {
            super(parent, desc, 9);
            this.list.setSelectionMode(0);
            this.list.setLayoutOrientation(0);
            this.list.setCellRenderer(new DefaultListCellRenderer(){
                private static final long serialVersionUID = 2263241758189661454L;

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    if (value != null) {
                        guiUtil.decorateCellRenderer(md, list::repaint, value, this, isSelected, cellHasFocus);
                    }
                    return this;
                }
            });
            JScrollPane listScroller = new JScrollPane(this.list);
            GridBagHelper gb = new GridBagHelper(this.getDialogPane());
            gb.addRow(listScroller, new double[]{1.0, 1.0});
            this.setResizable(true);
        }

        public T getObj() {
            IMerlinObj selection = (IMerlinObj)this.list.getSelectedValue();
            return (T)selection;
        }

        public void setObjs(List<T> availObjs, T selectedObject) {
            for (int m = 0; m < availObjs.size(); ++m) {
                IMerlinObj obj = (IMerlinObj)availObjs.get(m);
                boolean selected = obj.equals(selectedObject);
                this.model.addElement(obj);
                if (!selected) continue;
                this.list.setSelectedIndex(m);
            }
        }
    }
}

