/*
 * Decompiled with CFR 0.152.
 */
package ventus.geom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.IParametric2D;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.util.theUtil;

public class Inter2D {
    public static List<double[]> trimLineToPoly(List<? extends IParametric2D> poly, Point2d l1, Vector2d ldir, double tol) {
        ArrayList<Double> sortedIsects = new ArrayList<Double>();
        for (IParametric2D iParametric2D : poly) {
            List<double[]> isects = iParametric2D.getLineIsects(l1, ldir, tol);
            for (double[] isect : isects) {
                boolean comp0 = theUtil.eq0(isect[0], tol);
                boolean comp1 = theUtil.eq(isect[0], 1.0, tol);
                if (comp0 || comp1) {
                    double cross;
                    Vector2d tan = iParametric2D.getTangent(isect[0]);
                    if (comp1) {
                        tan.negate();
                    }
                    if (!theUtil.gt0(cross = Util2D.cross(ldir, tan), tol)) continue;
                    sortedIsects.add(isect[1]);
                    continue;
                }
                sortedIsects.add(isect[1]);
            }
        }
        if (sortedIsects.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        if (sortedIsects.size() == 1) {
            System.err.println("Encountered 1 intersection during line to poly trim.");
            return Collections.EMPTY_LIST;
        }
        Collections.sort(sortedIsects, (o1, o2) -> theUtil.compare(o1, o2, tol));
        if (sortedIsects.size() % 2 != 0) {
            System.err.println("Encounterd odd number of intersections during line to poly trim");
            return Arrays.asList(new double[][]{{(Double)sortedIsects.get(0), (Double)sortedIsects.get(sortedIsects.size() - 1)}});
        }
        ArrayList<double[]> validIsects = new ArrayList<double[]>();
        double[] dArray = theUtil.toDoubleArray(sortedIsects);
        for (int m = 0; m < dArray.length - 1; m += 2) {
            validIsects.add(new double[]{dArray[m], dArray[m + 1]});
        }
        validIsects.trimToSize();
        return validIsects;
    }

    public static double getAngle(Point3d center, Point3d from, Point3d to) {
        Vector3d leg1 = new Vector3d(from.x - center.x, from.y - center.y, 0.0);
        Vector3d leg2 = new Vector3d(to.x - center.x, to.y - center.y, 0.0);
        double angleRadSymmetric = Inter2D.angle(leg1, leg2);
        return angleRadSymmetric >= 0.0 ? angleRadSymmetric : angleRadSymmetric + Math.PI * 2;
    }

    public static double angle(Vector3d ref, Vector3d dir) {
        if (ref == null || dir == null) {
            return 0.0;
        }
        return Math.atan2(ref.x * dir.y - ref.y * dir.x, ref.x * dir.x + ref.y * dir.y);
    }
}

