/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.zone;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.swing.AbstractButton;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiMultiStateCheckBox;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.Events;
import thunderheadeng.util.Pair;
import thunderheadeng.util.PropValue;
import thunderheadeng.util.TypedProp;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.CompElementActions;
import ventus.actions.Undo;
import ventus.data.CompositePropertyUtil;
import ventus.data.IMerlinObj;
import ventus.data.MerlinSelectionModel;
import ventus.data.VentusData;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.data.schematics.geom.SchematicRoom;
import ventus.data.value.Schedule;
import ventus.feature.comps.ISelectionRibbon;
import ventus.feature.simparams.SimParamsFeature;
import ventus.feature.simparams.SimParamsProps;
import ventus.gui.guiUtil;
import ventus.gui.value.ScheduleField;
import ventus.mv.gui.PropConnections;
import ventus.mv.gui.SelectionEditorPanel;

public class ZoneRibbon
implements ISelectionRibbon {
    private final ArrayList<SelectionEditorPanel.EditorPanel> d_sections = new ArrayList();

    private void createSections() {
        this.d_sections.add(new RoomTypeSect());
        this.d_sections.add(new RoomPropSect());
    }

    @Override
    public boolean isEnabled(Set<TypedProp<?>> shared, Set<TypedProp<?>> unshared) {
        MerlinSelectionModel selection = Objects.requireNonNull(VentusApp.getAppData()).selection;
        return selection.isExclusive(SchematicRoom.class);
    }

    @Override
    public Collection<SelectionEditorPanel.EditorPanel> getSections() {
        if (this.d_sections.isEmpty()) {
            this.createSections();
        }
        return this.d_sections;
    }

    private static class RoomTypeSect
    extends SelectionEditorPanel.EditorPanel {
        private static final long serialVersionUID = -7690179246229293050L;
        private final guiComboBox<ISchematicRoom.Type> d_type = guiUtil.newCombo(t -> t == null ? new Pair<String, String>(Intl.intl("<mixed>"), null) : guiUtil.encodeToHtmlLabel(t.name, t.desc), ISchematicRoom.Type.values());

        public RoomTypeSect() {
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            gb.addRow(guiUtil.lblProp(SchematicRoom.TYPE), this.d_type);
            this.addConnection(new PropConnections.ComboPropConn<ISchematicRoom.Type>(new CompElementActions.DefProp(ISchematicRoom.TYPE), this.d_type));
        }
    }

    private static class RoomPropSect
    extends SelectionEditorPanel.EditorPanel {
        private static final long serialVersionUID = -7690179246229293050L;
        private final ScheduleField d_fldTemp;
        private final guiMultiStateCheckBox tempOverwrite;
        private final guiMultiStateCheckBox pressureOverwrite;

        public RoomPropSect() {
            this.d_fldTemp = new ScheduleField(SchematicRoom.TEMPERATURE_SCHEDULE.name, 14, UnitDoubleVR.UNBOUNDED);
            this.tempOverwrite = new guiMultiStateCheckBox(String.format(Intl.intl("%s:"), SchematicRoom.TEMPERATURE_SCHEDULE.name));
            this.tempOverwrite.setToolTipText("<html>" + Intl.intl("Temperature for this zone.<br>Determined by simulation parameters unless overwritten with constant or schedule value."));
            final CompElementActions.DefProp<IMerlinObj, Schedule> scheduleProp = new CompElementActions.DefProp<IMerlinObj, Schedule>(SchematicRoom.TEMPERATURE_SCHEDULE);
            TempConne tempConn = new TempConne(this.d_fldTemp, scheduleProp);
            LinkStatus.link((AbstractButton)this.tempOverwrite, this.d_fldTemp);
            PropConnections.BoolPropConnection checkboxPropConn = new PropConnections.BoolPropConnection(new CompElementActions.DefProp(SchematicRoom.TEMP_DEFINEDLOCALLY), this.tempOverwrite){

                @Override
                public void apply(CompElementActions.IObjectProp<IMerlinObj, Boolean> prop, Collection<? extends IMerlinObj> objs, Boolean val) {
                    Undo.begin(Intl.intl("Set Temperature Schedule Overwrite"));
                    VentusData md = VentusApp.getApp().getData();
                    prop.set(md, objs, val);
                    if (!tempOverwrite.isSelected()) {
                        SimParamsProps simData = VentusApp.getAppData().getComponentData(SimParamsFeature.GUID);
                        d_fldTemp.setValue(Schedule.newConstant(simData.get(SimParamsProps.defaultZoneTemp)));
                        scheduleProp.set(md, objs, d_fldTemp.getValue());
                    }
                    Undo.end(VentusApp.getApp().getData());
                }
            };
            this.pressureOverwrite = new guiMultiStateCheckBox(Intl.intl("Pressure:"));
            guiLabel pressureVariable = new guiLabel(Intl.intl("Variable"));
            LinkStatus.link((AbstractButton)this.pressureOverwrite, pressureVariable);
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            gb.addRow(this.tempOverwrite, this.d_fldTemp);
            gb.addRow(this.pressureOverwrite, pressureVariable);
            this.pressureOverwrite.setSelected(true);
            this.pressureOverwrite.setEnabled(false);
            pressureVariable.setEnabled(false);
            this.addConnection(tempConn);
            this.addConnection(checkboxPropConn);
        }

        private void updateState() {
            Collection<IMerlinObj> objs = this.getObjects();
            PropValue<ISchematicRoom.Type> type = CompositePropertyUtil.getValue(ISchematicRoom.TYPE, objs);
            this.setVisible(type.map(t -> t == ISchematicRoom.Type.ZONE).orElse(false));
        }

        @Override
        public void bind(Collection<IMerlinObj> objs) {
            super.bind(objs);
            this.updateState();
        }

        @Override
        public void update(Events events) {
            super.update(events);
            if (events.getEvents(ISchematicRoom.class, new Class[0]).hasChangedObjs()) {
                this.updateState();
            }
        }

        private class TempConne
        extends PropConnections.ScheduleProp {
            public TempConne(ScheduleField control, CompElementActions.IObjectProp<IMerlinObj, Schedule> prop) {
                super(prop, control);
            }

            public void commitSoTempCanUpdate() {
                this.runWhileLocked(() -> this.forceCommit());
            }

            @Override
            public void update(Events events) {
                MerlinSelectionModel sel;
                Set room;
                super.update(events);
                if ((events.getEvents(VentusData.class, new Class[0]).containsChange(VentusData.SIM_PARAMS_CHANGED) || events.getEvents(SchematicRoom.class, new Class[0]).containsChange(VentusData.SELECTION_CHANGED)) && !((SchematicRoom)(room = (sel = Objects.requireNonNull(VentusApp.getAppData()).selection).getSelected(SchematicRoom.class)).iterator().next()).getTempDefinedLocally()) {
                    SimParamsProps simData = VentusApp.getAppData().getComponentData(SimParamsFeature.GUID);
                    RoomPropSect.this.d_fldTemp.setValue(Schedule.newConstant(simData.get(SimParamsProps.defaultZoneTemp)));
                }
            }
        }
    }
}

