/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.zone;

import java.util.Map;
import org.jscience.physics.units.SI;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TypedProp;
import ventus.VentusApp;
import ventus.data.VentusData;
import ventus.data.schematics.Floor;
import ventus.data.schematics.FloorUtil;
import ventus.data.schematics.geom.SchematicRoom;
import ventus.feature.comps.IPrjDataWriter;
import ventus.io.contamx.PrjData;
import ventus.io.contamx.PrjUtil;

class ZonePrjDataWriterComp
implements IPrjDataWriter {
    ZonePrjDataWriterComp() {
    }

    @Override
    public IPrjDataWriter.Order getOrder() {
        return IPrjDataWriter.Order.BEFORE_NORMAL;
    }

    @Override
    public void addPrjData(VentusApp app, VentusData md, Map<TypedProp, Object> scenario, PrjData prjData) {
        for (SchematicRoom obj : md.floors.flattenRooms(SchematicRoom.class, t -> t.isWritable)) {
            Floor floor = FloorUtil.getFloor(md, obj);
            Pair<Integer, Double> temperature = PrjUtil.maybeWriteSchedule(prjData, obj.getTemperatureSchedule(), SI.KELVIN);
            PrjData.Zone zone = new PrjData.Zone(obj);
            prjData.zoneList.add(zone);
            prjData.nzone = prjData.zoneList.size();
            zone.nr = prjData.zoneList.size();
            zone.flags = 3;
            zone.ps = (Integer)temperature.v1;
            zone.pc = 0;
            zone.pk = 0;
            zone.pl = md.floors.indexOf(floor) + 1;
            zone.relHt = obj.getBaseOffsetAboveLevel().get(SI.METER);
            zone.vol = obj.getVolume().get(SI.METER.pow(3));
            zone.T0 = (Double)temperature.v2;
            zone.P0 = 0;
            zone.name = obj.getName();
            zone.color = -1;
            zone.u_Ht = 0;
            zone.uT = 0;
            zone.uP = 0;
            zone.uV = 0;
            zone.cdaxis = 0;
            zone.cdvf = 0;
            zone.cfd = 0;
        }
    }
}

