/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.zone;

import thunderheadeng.util.Warning;
import thunderheadeng.util.WarningReport;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.data.VentusData;
import ventus.data.schematics.Floor;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.geom.Geometry;
import ventus.io.IInputStreamFeatureHandler;
import ventus.io.VentusIO;
import ventus.io.VentusOIS;

public class ZoneOISWarnings
implements IInputStreamFeatureHandler {
    @Override
    public boolean applyVersionUpdates(int updateVersionNumber, int streamVersionNumber, VentusOIS.DecisionMaker responseHandler, VentusOIS.ChangeTracker changes, WarningReport warns, VentusData vd) {
        boolean modified = false;
        if (updateVersionNumber == VentusIO.Version.VER_220.num && streamVersionNumber < VentusIO.Version.VER_220.num) {
            for (Floor level : vd.floors.flatten(Floor.class)) {
                double levelGeomZ = level.getWorkingZ().get(Geometry.LENGTH_UNIT);
                for (ISchematicRoom zone : level.flatten(ISchematicRoom.class)) {
                    double zoneBaseZ = zone.getModel().getBoundingBox().getMin().z;
                    if (theUtil.eq(levelGeomZ, zoneBaseZ, 1.0E-6)) continue;
                    String msg = String.format(Intl.intl("Offset zone notice for \"%s\""), zone.getName());
                    String act = Intl.intl("Zone height now conforms to maximum Z for level.");
                    warns.addWarning(new Warning(msg, act));
                }
            }
        }
        return modified;
    }
}

