/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.windprofiles;

import thunderheadeng.util.NameGenerator;
import ventus.Intl;
import ventus.data.Composite;
import ventus.data.IMerlinObj;
import ventus.feature.windprofiles.WindProfile;
import ventus.util.MerlinUtil;

public class WindProfileRoot
extends Composite<WindProfile> {
    static final long serialVersionUID = 1L;
    private final NameGenerator d_nameGen = new NameGenerator(Intl.intl("windprofile"));

    public WindProfileRoot(String name) {
        super(name);
    }

    public String getSuggestedName() {
        return this.d_nameGen.generateName();
    }

    @Override
    public void add(IMerlinObj wp) {
        super.add(wp);
        this.d_nameGen.registerName(MerlinUtil.getName(wp));
    }

    @Override
    public void clear() {
        super.clear();
        this.d_nameGen.reset();
    }

    @Override
    public String getNewGroupName() {
        return Intl.intl("Wind Profile Group");
    }

    @Override
    public Composite<WindProfile> newGroup(String name) {
        return new WindProfileNode(name);
    }

    static class WindProfileNode
    extends Composite<WindProfile> {
        public WindProfileNode(String name) {
            super(name);
        }

        @Override
        public String getNewGroupName() {
            return Intl.intl("Wind Profile Group");
        }

        @Override
        public Composite<WindProfile> newGroup(String name) {
            return new WindProfileNode(name);
        }
    }
}

