/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.windprofiles;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JFrame;
import net.miginfocom.swing.MigLayout;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AddObject;
import ventus.actions.Undo;
import ventus.data.Composite;
import ventus.data.VentusData;
import ventus.feature.windprofiles.WindProfile;
import ventus.feature.windprofiles.WindProfileEditor;
import ventus.feature.windprofiles.WindProfileFeature;
import ventus.feature.windprofiles.WindProfileManager;
import ventus.feature.windprofiles.WindProfileRoot;
import ventus.gui.ManagerDlg;

public class WindProfileMgrDlg
extends ManagerDlg<WindProfile, WindProfileManager> {
    private static final long serialVersionUID = 1L;
    private final WindProfileEditor d_editor = new WindProfileEditor();
    private WindProfileManager d_manager;

    public WindProfileMgrDlg(JFrame owner, VentusApp app) {
        super(owner, app, Intl.intl("Edit Wind Profiles"), WindProfile.class);
        this.createActions();
        this.updateActions();
    }

    private void createActions() {
        this.addAction(new guiAction(Intl.intl("New..."), this::createNew));
        this.addAction(new ManagerDlg.LibraryAction(this, Intl.intl("Wind Profile"), vd -> (Composite)vd.getComponentData(WindProfileFeature.GUID), "lib/windprofile", "windprofile"));
        this.addAction(new ManagerDlg.RenameAction(this, WindProfile.NAME), x$0 -> super.canRename(x$0));
        this.addAction(new ManagerDlg.DeleteAction(this), x$0 -> super.canDelete(x$0));
    }

    public void init(VentusData data, WindProfileManager manager, WindProfile node) {
        super.init(data, manager, this.d_editor, WindProfileFeature.s_icon_windProfile);
        this.d_manager = manager;
        this.updateActions();
        this.getList().select(node);
        ManagerDlg.defaultInit(this.d_editor, node, obj -> {});
    }

    public void createNew(ActionEvent event) {
        this.preSave();
        WindProfileRoot root = this.d_manager.getRoot();
        final guiTextField nameField = new guiTextField(root.getSuggestedName());
        guiPanel namePanel = new guiPanel(new MigLayout("fill, insets 0")){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validateData(boolean showWarn, boolean allowModify) {
                if (!super.validateData(showWarn, allowModify)) {
                    return false;
                }
                return WindProfileMgrDlg.this.validateName(true, true).test(null, nameField.getValue());
            }
        };
        namePanel.add((Component)new guiLabel(Intl.intl("Name:")), "growx");
        namePanel.add((Component)nameField, "growx, wrap");
        guiDialog dlg = new guiDialog((Window)this, Intl.intl("New Wind Profile"), 9);
        dlg.setDialogComponent(namePanel);
        if (dlg.doModal() == 1) {
            Undo.begin(Intl.intl("Create Wind Profile"));
            AddObject.add(this.getVentusData(), root, List.of(new WindProfile(nameField.getValue())));
            Undo.end(this.getVentusData());
        }
    }
}

