/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.windprofiles;

import org.jscience.physics.units.Unit;
import thunderheadeng.gui.Mediator;
import ventus.data.property.Function1dProp;
import ventus.data.value.APiecewiseFunction1d;
import ventus.data.value.CubicSplineFunction;
import ventus.data.value.PiecewiseFunction1d;
import ventus.data.value.TrigonometricFunction;
import ventus.feature.windprofiles.WindProfile;
import ventus.gui.value.PiecewiseFunction1dEditor;
import ventus.unitsystem.SIUS;

public class WindProfileFunction1dEditor
extends PiecewiseFunction1dEditor {
    private static final long serialVersionUID = 1L;
    private WindProfile.CurveType d_curveType = WindProfile.CurveType.LINEAR;
    private final Unit d_ux;
    private final Unit d_uy;

    public WindProfileFunction1dEditor(Function1dProp prop) {
        super(prop);
        this.d_ux = SIUS.unit(WindProfile.PROP_FUNDAMENTAL.x.unitType);
        this.d_uy = SIUS.unit(WindProfile.PROP_FUNDAMENTAL.y.unitType);
    }

    @Override
    public APiecewiseFunction1d saveValue(Mediator mediator) {
        APiecewiseFunction1d func = null;
        if (this.d_curveType == WindProfile.CurveType.LINEAR) {
            func = super.saveValue(null);
        } else if (this.d_curveType == WindProfile.CurveType.CUBIC) {
            func = this.saveValueCubicSpline();
        } else if (this.d_curveType == WindProfile.CurveType.TRIG) {
            func = this.saveValueTrig();
        }
        return func;
    }

    private APiecewiseFunction1d saveValueCubicSpline() {
        return new CubicSplineFunction(this.getEntries());
    }

    private APiecewiseFunction1d saveValueTrig() {
        return new TrigonometricFunction(WindProfile.PROP_FUNDAMENTAL, this.getEntries());
    }

    public void loadValueLinear(APiecewiseFunction1d var) {
        this.d_curveType = WindProfile.CurveType.LINEAR;
        this.loadValue(new PiecewiseFunction1d(var.getInput()));
        this.updateValue();
    }

    public void loadValueTrigonometric(APiecewiseFunction1d var) {
        this.d_curveType = WindProfile.CurveType.TRIG;
        this.loadValue(new TrigonometricFunction(WindProfile.PROP_FUNDAMENTAL, var.getInput()));
        this.updateValue();
    }

    public void loadValueCubicSpline(APiecewiseFunction1d var) {
        this.d_curveType = WindProfile.CurveType.CUBIC;
        this.loadValue(new CubicSplineFunction(var.getInput()));
        this.updateValue();
    }

    public int getRowCount() {
        return this.getTableModel().getRowCount();
    }
}

