/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.weather;

import java.util.Map;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.TypedProp;
import ventus.VentusApp;
import ventus.data.VentusData;
import ventus.feature.comps.DefaultFlatDataModel;
import ventus.feature.comps.IPrjDataWriter;
import ventus.feature.weather.WeatherProps;
import ventus.io.contamx.PrjData;

public class PrjDataWriterWeatherComp
implements IPrjDataWriter {
    DefaultFlatDataModel<WeatherProps> d_dm;

    public PrjDataWriterWeatherComp(DefaultFlatDataModel<WeatherProps> dm) {
        this.d_dm = dm;
    }

    @Override
    public IPrjDataWriter.Order getOrder() {
        return IPrjDataWriter.Order.NORMAL;
    }

    @Override
    public void addPrjData(VentusApp app, VentusData md, Map<TypedProp, Object> scenario, PrjData prjData) {
        WeatherProps props = this.d_dm.getProps(md);
        prjData.steadyStateSim.Ta = this.getUdScenario(WeatherProps.ambientTemp, scenario).get(SI.KELVIN);
        prjData.steadyStateSim.Pb = props.get(WeatherProps.absPressure).get(SI.PASCAL);
        prjData.steadyStateSim.rh = props.get(WeatherProps.relativeHumidity);
        prjData.steadyStateSim.Ws = props.get(WeatherProps.windSpeed).get(SI.METER.divide(SI.SECOND));
        prjData.steadyStateSim.Wd = this.getUdScenario(WeatherProps.windDirection, scenario).get(NonSI.DEGREE_ANGLE);
        prjData.steadyStateSim.unitsCollection[0] = 0;
        prjData.steadyStateSim.unitsCollection[1] = 0;
        prjData.steadyStateSim.unitsCollection[2] = 0;
        prjData.steadyStateSim.unitsCollection[3] = 0;
        prjData.wH = props.get(WeatherProps.roofWallHeight).get(SI.METER);
        prjData.u = 0;
        prjData.Ao = props.get(WeatherProps.localTerrainConst);
        prjData.a = props.get(WeatherProps.velocityProfileExpo);
    }

    private UnitDouble getUdScenario(TypedProp prop, Map<TypedProp, Object> scenario) {
        return (UnitDouble)scenario.get(prop);
    }
}

