/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.weather;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.JEditorPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import net.miginfocom.swing.MigLayout;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;
import ventus.Intl;
import ventus.gui.guiUtil;

public class ListValueEditor {
    public final JEditorPane linkButton;
    public final JTextField field;
    private final String d_dlgTitle;
    private final List<UnitDouble> d_value;
    private final Unit d_unit;

    public ListValueEditor(String quantName, Unit unit) {
        this.d_dlgTitle = quantName;
        this.field = new guiTextField();
        this.field.setEditable(false);
        this.d_value = new ArrayList<UnitDouble>();
        this.d_unit = unit;
        this.linkButton = guiUtil.newHTMLLabel();
        this.linkButton.setText(String.format("<html><a href=\"blank\">%s</a></html>", Intl.intl("edit")));
        this.linkButton.setToolTipText(Intl.intl("Multiple values for multiple simulations"));
        this.linkButton.addHyperlinkListener(evt -> {
            if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED && this.linkButton.isEnabled()) {
                this.showEditorDlg();
            }
        });
    }

    public void setValue(List<UnitDouble> values) {
        this.d_value.clear();
        this.d_value.addAll(values);
        this.update();
        this.setContainerModified(true);
    }

    private void setContainerModified(boolean flag) {
        Container container = SwingUtilities.getAncestorOfClass(Modifiable.class, this.linkButton);
        if (container != null) {
            ((Modifiable)((Object)container)).setModified(flag);
        }
    }

    public List<UnitDouble> getValue() {
        return this.d_value;
    }

    private void update() {
        String desc = this.d_value.stream().map(val -> {
            UnitDouble converted_val = val.convert(this.d_unit);
            return Global.format(converted_val);
        }).collect(Collectors.joining(", "));
        this.field.setText(desc);
    }

    private void showEditorDlg() {
        String[] headers = new String[]{String.format(Intl.intl("Values (%s)"), this.d_unit.toString())};
        Class[] colClasses = new Class[]{UnitDouble.class};
        final guiTableEditor tableEditor = new guiTableEditor(guiTableUtil.fixedColumnTable(headers, colClasses, this.d_value.size(), 100, 24), 30);
        tableEditor.getTable().setNullValuesAllowed(false);
        tableEditor.getTable().autoSizeColumns(700);
        tableEditor.getTable().getColumnModel().getColumn(0).setPreferredWidth(150);
        tableEditor.getTable().getColumnModel().getColumn(0).setCellEditor(new guiTable.UnitDoubleEditor(this.d_unit));
        tableEditor.getTable().getColumnModel().getColumn(0).setCellRenderer(new guiTable.UnitDoubleRenderer(this.d_unit));
        tableEditor.getTable().setPreferredScrollableViewportSize(new Dimension(tableEditor.getTable().getPreferredSize().width, Math.max(300, tableEditor.getTable().getPreferredSize().height)));
        guiDialog dlg = new guiDialog(SwingUtilities.getWindowAncestor(this.linkButton), this.d_dlgTitle, 9){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validateData(boolean showWarn, boolean allowModify) {
                if (!super.validateData(showWarn, showWarn)) {
                    return false;
                }
                if (tableEditor.getTable().getModel().getRowCount() <= 0) {
                    this.showMessageBox(Intl.intl("At least one value required."));
                    return false;
                }
                return true;
            }
        };
        guiPanel dlgPane = dlg.getDialogPane();
        dlgPane.setLayout(new MigLayout());
        dlgPane.add(new guiLabel(Intl.intl("Enter multiple values to run multiple scenarios.")));
        dlgPane.add((Component)tableEditor, "newline");
        for (int i = 0; i < this.d_value.size(); ++i) {
            tableEditor.getTable().setValueAt(this.d_value.get(i), i, 0);
        }
        if (dlg.doModal() == 1) {
            ArrayList<UnitDouble> updatedValues = new ArrayList<UnitDouble>();
            for (int i = 0; i < tableEditor.getTable().getModel().getRowCount(); ++i) {
                UnitDouble value = (UnitDouble)tableEditor.getTable().getModel().getValueAt(i, 0);
                Objects.requireNonNull(value, "Null value in ListValEditor");
                updatedValues.add(value);
            }
            this.setValue(updatedValues);
        }
    }
}

