/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.tags;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ventus.Intl;
import ventus.feature.tags.PredefTags;

public class StringTagsUtil {
    private static final Set<String> DEFAULT_PREDEF_TAGS = Stream.of(PredefTags.values()).map(t -> t.name).sorted((t1, t2) -> t1.compareToIgnoreCase((String)t2)).collect(Collectors.toCollection(() -> new LinkedHashSet()));

    public static Set<String> getDefaultPredefTags() {
        return DEFAULT_PREDEF_TAGS;
    }

    public static Predicate<String> getValidTagNamePredicate() {
        return s -> {
            try {
                Set<String> parsedTags = StringTagsUtil.parse(s, true, false, StringTagsUtil.getDefaultPredefTags());
                if (parsedTags.isEmpty()) {
                    return false;
                }
                if (parsedTags.size() > 1) {
                    return false;
                }
                if (parsedTags.size() == 1) {
                    return parsedTags.iterator().next().equals(s);
                }
                assert (false);
                return true;
            }
            catch (ParseException e) {
                return false;
            }
        };
    }

    public static Set<String> parse(String text, boolean allowEmpty, boolean allowPredefs, Set<String> predefTags) throws ParseException {
        List tags = Stream.of(text.split("[ ,;]+")).map(s -> s.trim().toLowerCase(Locale.ROOT)).filter(s -> !s.isEmpty()).collect(Collectors.toCollection(() -> new ArrayList()));
        if (!allowEmpty && tags.isEmpty()) {
            throw new ParseException(Intl.intl("At least one tag must be specified."), 0);
        }
        if (tags.isEmpty()) {
            return Collections.emptySet();
        }
        if (tags.size() == 1) {
            return Collections.singleton((String)tags.get(0));
        }
        return new LinkedHashSet<String>(tags);
    }

    public static String format(Set<String> val) {
        return String.join((CharSequence)" ", val);
    }
}

