/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.sourcesink;

import java.util.Map;
import org.jscience.physics.units.Unit;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TypedProp;
import ventus.VentusApp;
import ventus.data.VentusData;
import ventus.feature.comps.IPrjDataWriter;
import ventus.feature.sourcesink.SourceSink;
import ventus.feature.sourcesink.SourceSinkFeature;
import ventus.feature.sourcesink.SourceSinkRoot;
import ventus.io.contamx.PrjData;
import ventus.io.contamx.PrjUtil;

public class SourceSinkPrjWriter
implements IPrjDataWriter {
    @Override
    public IPrjDataWriter.Order getOrder() {
        return IPrjDataWriter.Order.AFTER_NORMAL;
    }

    @Override
    public void addPrjData(VentusApp app, VentusData md, Map<TypedProp, Object> scenario, PrjData prjData) {
        SourceSinkRoot root = (SourceSinkRoot)md.getComponentData(SourceSinkFeature.GUID);
        for (SourceSink in : root.flatten(SourceSink.class)) {
            if (!in.isEnabled()) continue;
            Pair<Integer, Double> multiplier = PrjUtil.maybeWriteSchedule(prjData, in.get(SourceSink.MULTIPLIER), Unit.ONE);
            PrjData.SourceSink out = new PrjData.SourceSink(in);
            prjData.sourceSinkList.add(out);
            out.nr = prjData.ncss = prjData.sourceSinkList.size();
            out.pz = prjData.findZone((Object)in.get(SourceSink.ROOM)).nr;
            out.pe = prjData.findSourceSinkElem((Object)in.get(SourceSink.ELEMENT)).nr;
            out.ps = (Integer)multiplier.v1;
            out.pc = 0;
            out.mult = (Double)multiplier.v2;
            out.CC0 = 0.0;
            out.Xmin = 0.0;
            out.Ymin = 0.0;
            out.Hmin = 0.0;
            out.Xmax = 0.0;
            out.Ymax = 0.0;
            out.Hmax = 0.0;
            out.u_XYZ = -1;
            out.vf_type = 0;
            out.vf_node_name = "0";
            out.cfd = 0;
            out.name = "";
        }
    }
}

