/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.sourcesink;

import org.jscience.physics.units.Unit;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Warning;
import thunderheadeng.util.WarningReport;
import ventus.Intl;
import ventus.data.VentusData;
import ventus.data.value.Schedule;
import ventus.data.value.ScheduleUtil;
import ventus.feature.sourcesink.SourceSink;
import ventus.feature.sourcesink.SourceSinkFeature;
import ventus.feature.sourcesink.SourceSinkRoot;
import ventus.io.IInputStreamFeatureHandler;
import ventus.io.VentusOIS;

public class SourceSinkOISHandler
implements IInputStreamFeatureHandler {
    @Override
    public boolean applyVersionUpdates(int updateVer, int streamVer, VentusOIS.DecisionMaker responseHandler, VentusOIS.ChangeTracker changes, WarningReport warns, VentusData vd) {
        if (updateVer == 212 && streamVer < 212) {
            vd.setComponentData(SourceSinkFeature.GUID, new SourceSinkRoot());
            return true;
        }
        if (updateVer == 216 && streamVer < 216) {
            Schedule multiplier;
            boolean changed = false;
            SourceSinkRoot root = (SourceSinkRoot)vd.getComponentData(SourceSinkFeature.GUID);
            UnitDouble zero = new UnitDouble(0.0, Unit.ONE);
            for (SourceSink sourceSink : root.flatten(SourceSink.class)) {
                multiplier = sourceSink.get(SourceSink.MULTIPLIER);
                if (!multiplier.allValues().anyMatch(val -> val.lt(zero, 1.0E-9))) continue;
                sourceSink.set(SourceSink.MULTIPLIER, multiplier.transform(UnitDouble::abs));
                warns.addWarning(new Warning(String.format(Intl.intl("Multiplier for Source/Sink, \"%1$s\", had out-of-order time entries."), sourceSink.getName()), Intl.intl("Sorted multiplier schedule.")));
                changed = true;
            }
            for (SourceSink sourceSink : root.flatten(SourceSink.class)) {
                multiplier = sourceSink.get(SourceSink.MULTIPLIER);
                if (ScheduleUtil.isTimeSorted(multiplier)) continue;
                sourceSink.set(SourceSink.MULTIPLIER, ScheduleUtil.fixTimeSort(multiplier));
                warns.addWarning(new Warning(String.format(Intl.intl("Multiplier for Source/Sink, \"%1$s\", had a negative value."), sourceSink.getName()), Intl.intl("Removed negative values from the multiplier.")));
                changed = true;
            }
            return changed;
        }
        return false;
    }
}

