/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.sourcesink;

import java.util.Collection;
import thunderheadeng.util.NameGenerator;
import ventus.Intl;
import ventus.data.Composite;
import ventus.data.IMerlinObj;
import ventus.feature.sourcesink.SourceSinkElement;
import ventus.util.MerlinUtil;

public class SourceSinkElementRoot
extends Composite<SourceSinkElement> {
    static final long serialVersionUID = 1L;
    private NameGenerator d_nameGen = new NameGenerator(Intl.intl("SourceSinkElement"));

    public SourceSinkElementRoot() {
        super(Intl.intl("Source/Sink Elements"));
    }

    public void reset() {
        this.clear();
        this.d_nameGen.reset();
    }

    @Override
    public void restoreFrom(Object obj) {
        super.restoreFrom(obj);
        if (obj instanceof SourceSinkElementRoot) {
            SourceSinkElementRoot root = (SourceSinkElementRoot)obj;
            this.d_nameGen = root.d_nameGen;
        }
    }

    public String nextName() {
        String name = this.d_nameGen.generateName();
        this.d_nameGen.registerName(name);
        return name;
    }

    public NameGenerator getNameGenerator() {
        return this.d_nameGen;
    }

    @Override
    public void add(IMerlinObj elem) {
        super.add(elem);
        this.d_nameGen.registerName(MerlinUtil.getName(elem));
    }

    public SourceSinkElement getDefault() {
        Collection<SourceSinkElement> elements = this.getDeepMembers(SourceSinkElement.class);
        if (!elements.isEmpty()) {
            return elements.iterator().next();
        }
        return null;
    }

    @Override
    public Composite<SourceSinkElement> newGroup(String name) {
        return new SourceSinkElementNode(name);
    }

    @Override
    public String getNewGroupName() {
        return Intl.intl("Source/Sink Element Group");
    }

    static class SourceSinkElementNode
    extends Composite<SourceSinkElement> {
        private static final long serialVersionUID = 1L;

        public SourceSinkElementNode(String name) {
            super(name);
        }

        @Override
        public Composite<SourceSinkElement> newGroup(String name) {
            return new SourceSinkElementNode(name);
        }

        @Override
        public String getNewGroupName() {
            return Intl.intl("Source/Sink Element Group");
        }
    }
}

