/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.sourcesink;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.JFrame;
import net.miginfocom.swing.MigLayout;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.util.NameGenerator;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AddObject;
import ventus.actions.Undo;
import ventus.data.VentusData;
import ventus.feature.sourcesink.SourceSinkElement;
import ventus.feature.sourcesink.SourceSinkElementData;
import ventus.feature.sourcesink.SourceSinkElementEditor;
import ventus.feature.sourcesink.SourceSinkElementManager;
import ventus.feature.sourcesink.SourceSinkElementRoot;
import ventus.feature.species.Species;
import ventus.feature.species.SpeciesData;
import ventus.feature.species.SpeciesRoot;
import ventus.gui.ManagerDlg;
import ventus.gui.guiUtil;
import ventus.unitsystem.UnitSystem;

public class SourceSinkElementMgrDlg
extends ManagerDlg<SourceSinkElement, SourceSinkElementManager> {
    private static final long serialVersionUID = 1L;
    private final SourceSinkElementEditor d_editor;
    private SourceSinkElementManager d_manager;
    private final VentusData d_vd;

    public SourceSinkElementMgrDlg(JFrame owner, VentusApp app, UnitSystem us) {
        super(owner, app, Intl.intl("Edit Source/Sink Elements"), SourceSinkElement.class);
        this.d_editor = new SourceSinkElementEditor(app.getData(), us);
        this.d_vd = app.getData();
        this.createActions();
        this.updateActions();
    }

    private void createActions() {
        this.addAction(new guiAction(Intl.intl("New..."), this::createNew));
        this.addAction(new guiAction(Intl.intl("Duplicate..."), this::duplicate), this::canDuplicate);
        this.addAction(new ManagerDlg.RenameAction(this, SourceSinkElement.NAME), x$0 -> super.canRename(x$0));
        this.addAction(new ManagerDlg.DeleteAction(this), x$0 -> super.canDelete(x$0));
    }

    public void init(VentusData data, SourceSinkElementManager manager, SourceSinkElement node) {
        super.init(data, manager, this.d_editor, SourceSinkElementData.ICON);
        this.d_manager = manager;
        if (node == null) {
            this.getList().select(0);
        } else {
            this.getList().select(node);
        }
        this.d_editor.init((SourceSinkElement)this.getList().getSelectedItem());
    }

    public void createNew(ActionEvent event) {
        this.preSave();
        SourceSinkElementRoot root = this.d_manager.getRoot();
        NameGenerator ng = root.getNameGenerator();
        final guiTextField nameField = new guiTextField(ng.generateValidName(Intl.intl("SourceSinkElement")));
        guiPanel namePanel = new guiPanel(new MigLayout("fill, insets 0")){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validateData(boolean showWarn, boolean allowModify) {
                if (!super.validateData(showWarn, allowModify)) {
                    return false;
                }
                return SourceSinkElementMgrDlg.this.validateName(true, true).test(null, nameField.getValue());
            }
        };
        namePanel.add((Component)guiUtil.lblProp(SourceSinkElement.NAME), "growx");
        namePanel.add((Component)nameField, "growx, wrap");
        guiDialog dlg = new guiDialog((Window)this, Intl.intl("New Source/Sink Element"), 9);
        dlg.setDialogComponent(namePanel);
        if (dlg.doModal() == 1) {
            Undo.begin(Intl.intl("Create Source/Sink Element"));
            AddObject.add(this.d_vd, root, List.of(new SourceSinkElement(nameField.getValue(), this.getFirstSpecies())));
            Undo.end(this.d_vd);
        }
    }

    private Species getFirstSpecies() {
        SpeciesRoot root = (SpeciesRoot)this.d_vd.getComponentData(SpeciesData.GUID);
        Collection<Species> speciesList = root.flatten(Species.class);
        if (speciesList.size() > 0) {
            return speciesList.iterator().next();
        }
        return null;
    }

    protected boolean canDuplicate(SourceSinkElement element) {
        return element != null;
    }

    public void duplicate(ActionEvent event) {
        this.preSave();
        SourceSinkElementRoot root = this.d_manager.getRoot();
        SourceSinkElement selected = (SourceSinkElement)this.getList().getSelectedItem();
        guiComboBox<SourceSinkElement> basedOnComboBox = new guiComboBox<SourceSinkElement>(this.d_manager.getSorted());
        basedOnComboBox.setSelectedItem(selected);
        final guiTextField nameField = new guiTextField();
        nameField.setText(root.getNameGenerator().generateValidName(selected.getName()));
        basedOnComboBox.addItemListener(evt -> {
            if (evt.getStateChange() == 1 && !nameField.isModified()) {
                SourceSinkElement item = (SourceSinkElement)evt.getItem();
                nameField.setText(root.getNameGenerator().generateValidName(item.getName()));
            }
        });
        guiPanel namePanel = new guiPanel(new MigLayout("fill, insets 0")){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validateData(boolean showWarn, boolean allowModify) {
                if (!super.validateData(showWarn, allowModify)) {
                    return false;
                }
                return SourceSinkElementMgrDlg.this.validateName(true, true).test(null, nameField.getValue());
            }
        };
        namePanel.add((Component)new guiLabel(Intl.intl("Name:")), "growx");
        namePanel.add((Component)nameField, "growx, wrap");
        namePanel.add((Component)new guiLabel(Intl.intl("Based On:")), "growx");
        namePanel.add(basedOnComboBox, "growx, wrap");
        guiDialog dlg = new guiDialog((Window)this, Intl.intl("Duplicate Source/Sink Element"), 9);
        dlg.setDialogComponent(namePanel);
        if (dlg.doModal() == 1) {
            String name = nameField.getValue();
            SourceSinkElement element = basedOnComboBox.getSelectedItem() != null ? basedOnComboBox.getSelectedItem().clone() : new SourceSinkElement(name, this.getFirstSpecies());
            element.setName(name);
            Undo.begin(Intl.intl("Duplicate Source/Sink Element"));
            AddObject.add(this.d_vd, root, List.of(new SourceSinkElement(nameField.getValue(), this.getFirstSpecies())));
            Undo.end(this.d_vd);
        }
    }
}

