/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.sourcesink;

import java.util.ArrayList;
import javax.swing.ImageIcon;
import thunderheadeng.util.GroupedSequence;
import ventus.EntryPointHelper;
import ventus.Intl;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.SimError;
import ventus.feature.CompositeFeatureGuid;
import ventus.feature.comps.FeatureUtil;
import ventus.feature.comps.IDataModel;
import ventus.feature.sourcesink.SourceSinkElement;
import ventus.feature.sourcesink.SourceSinkElementRoot;
import ventus.gui.guiUtil;

public class SourceSinkElementData
implements IDataModel {
    public static final CompositeFeatureGuid<SourceSinkElementRoot, SourceSinkElement> GUID = new CompositeFeatureGuid<SourceSinkElementRoot, SourceSinkElement>("SourceSinkElement.data", SourceSinkElementRoot.class, SourceSinkElement.class);
    public static final int SEQ_IX = 53;
    public static final ImageIcon ICON = guiUtil.loadIconSvg(FeatureUtil.getRequiredResource(SourceSinkElement.class, "icons/source-sink-element.svg"), 16);

    @Override
    public void init(VentusData md) {
        md.setComponentData(GUID, new SourceSinkElementRoot());
    }

    @Override
    public void reset(VentusData md) {
        ((SourceSinkElementRoot)md.getComponentData(GUID)).reset();
    }

    private static SourceSinkElementRoot getDataRoot(VentusData md) {
        return (SourceSinkElementRoot)md.getComponentData(GUID);
    }

    @Override
    public void loadFrom(VentusData src, VentusData dest) {
        SourceSinkElementRoot srcData = SourceSinkElementData.getDataRoot(src);
        SourceSinkElementRoot destData = SourceSinkElementData.getDataRoot(dest);
        destData.restoreFrom(srcData);
        dest.replaceInSel(srcData, destData);
    }

    @Override
    public void addTreeRoots(VentusData md, GroupedSequence roots) {
        roots.add(53, md.getComponentData(GUID));
    }

    @Override
    public void registerEntryPointData() {
        EntryPointHelper<SourceSinkElementRoot> rootHelper = EntryPointHelper.rootEP(SourceSinkElementRoot.class, ICON, Intl.intl("Source Sink Element Root"));
        rootHelper.register();
        EntryPointHelper<SourceSinkElementRoot.SourceSinkElementNode> compHelper = EntryPointHelper.groupEP(GUID, SourceSinkElementRoot.SourceSinkElementNode.class, SourceSinkElementRoot.SourceSinkElementNode.PROP_TYPES, ICON, Intl.intl("Source Sink Element Group"));
        compHelper.register();
        EntryPointHelper<SourceSinkElement> nodeHelper = EntryPointHelper.objectEP(GUID, SourceSinkElement.class, SourceSinkElement.PROP_TYPES, (md, obj, unused) -> {
            if (obj == null) {
                return ICON;
            }
            return guiUtil.loadIconSvg(SourceSinkElement.class.getResource("icons/source-sink-element.svg"), obj.get(SourceSinkElement.COLOR), 16);
        }, (md, obj) -> Intl.intl("Source Sink Element"));
        nodeHelper.getErrors = (vd, obj) -> {
            ArrayList<SimError> errors = new ArrayList<SimError>();
            if (obj.get(SourceSinkElement.SPECIES) == null) {
                errors.add(new SimError(SimError.Level.CRITICAL, String.format(Intl.intl("%s does not have a Species."), obj.getName()), Intl.intl("Delete Source/Sink Element or set its Species."), (IMerlinObj)obj));
            }
            return errors;
        };
        nodeHelper.register();
    }
}

