/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.sourcesink;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.Unit;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.gui.framework.property.PropertyDefsFramework;
import thunderheadeng.gui.framework.property.TeciDisplayProps;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.ICyclicSurrogate;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;
import ventus.Intl;
import ventus.data.IMerlinObj;
import ventus.data.NamedMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.Floor;
import ventus.data.schematics.ISchematicObj;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.data.value.Schedule;
import ventus.feature.ahs.AHSPoint;
import ventus.feature.props.DisplayProps;
import ventus.feature.props.PropComparisons;
import ventus.feature.props.PropertyDefs;
import ventus.feature.sourcesink.SourceSinkElement;
import ventus.feature.sourcesink.SourceSinkElementData;
import ventus.feature.tags.Tag;
import ventus.feature.tags.TagsUtil;
import ventus.geom.GeomUtil;
import ventus.geom.PointEntityGeom;
import ventus.io.VentusIO;
import ventus.io.VentusOIS;
import ventus.mv.tools.RoomSnapConstraint;
import ventus.util.Dependencies;

public class SourceSink
extends NamedMerlinObj
implements Serializable,
ISchematicObj,
IDirectDependent<VentusData>,
ICyclicSurrogate,
IEventObserver {
    private static final long serialVersionUID = 1L;
    public static final PropertyDefs<SourceSink> PROP_TYPES = PropertyDefs.defsInheritPropsOnly(SourceSink.class, new PropertyDefsFramework.Storage<SourceSink>(obj -> obj.d_properties, obj -> obj.d_transientProps, obj -> {
        obj.d_properties = new PropertySet();
        obj.d_transientProps = new PropertySet();
    }), NamedMerlinObj.PROP_TYPES);
    public static final DisplayProp<Boolean> ENABLED = PROP_TYPES.storeAsPlainOldData(VentusData.ENABLED).attrFireEvents((p, fp) -> fp.changedEvt(p, EventChannel.EVT_GENERAL, VentusData.TOPOLOGY)).attrFinish();
    static final TypedProp<Boolean> STORED_VISIBILITY = ((TypedProps.Builder)TypedProps.build((Object)"SourceSink.VISIBILITY", true).attrMarkers(VentusData.VISIBILITY_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrSurrogateEquals(null).attrFinish();
    public static final DisplayProp<Boolean> VISIBILITY = PROP_TYPES.storeAsWrapper(VentusData.VISIBILITY).attrGetter(SourceSink::isVisible, Stream.of(STORED_VISIBILITY, ENABLED)).attrSetter(SourceSink::setVisible, null).attrUndoPropRestore(false, STORED_VISIBILITY).attrFinish();
    public static final DisplayProp<Set<Tag>> TAGS = TagsUtil.newTagsProp(PROP_TYPES);
    public static final TypedProp<ISchematicRoom> ROOM = TypedProps.build((Object)"SourceSink.ROOM", ISchematicRoom.class).attrStoreAsTopologyDirect(PROP_TYPES).attrDependency(prop -> Dependencies.newDependencyContainedBy(ISchematicRoom.class)).attrSurrogateEquals(null).attrFinish();
    public static final TypedProp<Point3d> LOCATION = TypedProps.build("SourceSink.LOCATION", Point3d.class, new Point3d(0.0, 0.0, 0.0)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<Vector3d> ROOM_NORMAL = TypedProps.build("SourceSink.ROOM_NORMAL", Vector3d.class, new Vector3d(0.0, 0.0, 1.0)).attrStoreAsPlainOldData(PROP_TYPES).attrSurrogateEquals(null).attrFinish();
    public static final DisplayProp<Schedule> MULTIPLIER = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SourceSink.MULTIPLIER", Schedule.class, Schedule.newConstant(new UnitDouble(1.0, Unit.ONE)), Intl.intl("Multiplier"), Intl.intl("Multiplier applied to the contaminant generation and removal rate.")).attrFormatValue(sch -> sch.format(10))).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().schedule(10)).attrFinish();
    public static final DisplayProp<SourceSinkElement> ELEMENT = DisplayProps.build((Object)"SourceSink.ELEMENT", SourceSinkElement.class, null, Intl.intl("Element"), Intl.intl("Source/Sink element defining the contaminant species,\nas well as the generation and removal rate.")).attrStoreAsPlainOldData(PROP_TYPES).attrDependency(prop -> Dependencies.newDependencyAsValue(prop, DLink.STRONG, SourceSinkElement.class, Predicates.alwaysTrue())).attrComparisonEditor(PropComparisons.factory().singleObj(PropComparisons.getFeatureSrc(SourceSinkElementData.GUID, Intl.intl("<none>")))).attrFinish();
    public static final DisplayProp<Floor> LEVEL = PROP_TYPES.storeAsReadOnly(VentusData.LEVEL).attrGetter(SourceSink::getLevel, ROOM).attrFinish();
    private PropertySet d_properties = new PropertySet();
    private transient PropertySet d_transientProps = new PropertySet();

    public SourceSink(String name) {
        super(name);
    }

    private void readObject(ObjectInputStream is) throws ClassNotFoundException, IOException {
        is.defaultReadObject();
        this.d_transientProps = new PropertySet();
        if (this.d_properties.isDefined(ROOM)) {
            this.d_transientProps.setIfNotDefault(ROOM, this.d_properties.get(ROOM));
            this.d_properties.remove(ROOM);
        }
        if (this.d_properties.isDefined(VISIBILITY)) {
            this.d_properties.set(STORED_VISIBILITY, this.d_properties.get(VISIBILITY));
            this.d_properties.remove(VISIBILITY);
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    protected void addToDomain(VentusData domain, IMerlinObj parent) {
        super.addToDomain(domain, parent);
        domain.getEvents().addObserverInDomain((IEventObserver)this, SourceSinkElement.class, false, false, SourceSinkElement.COLOR);
    }

    @Override
    protected void removeFromDomain(VentusData domain, IMerlinObj parent) {
        domain.getEvents().removeObserverInDomain(this);
        super.removeFromDomain(domain, parent);
    }

    public Floor getLevel() {
        ISchematicRoom zone = this.get(ROOM);
        return zone != null ? zone.getLevel() : null;
    }

    public SourceSinkElement getElement() {
        return this.get(ELEMENT);
    }

    public boolean isEnabled() {
        return this.get(ENABLED);
    }

    public void setEnabled(boolean enabled) {
        this.setToPropertySet(ENABLED, enabled);
    }

    @Override
    public boolean isVisible() {
        return this.get(STORED_VISIBILITY) != false && this.get(ENABLED) != false;
    }

    @Override
    public void setVisible(boolean visible) {
        this.set(STORED_VISIBILITY, visible);
    }

    @Override
    public Collection<? extends ISchematicObj> getConnections() {
        return this.get(ROOM) != null ? Collections.singleton(this.get(ROOM)) : Collections.emptyList();
    }

    @Override
    public boolean hasOpenSpots(Class<? extends ISchematicObj> type) {
        return this.get(ROOM) == null;
    }

    @Override
    public void disconnectFrom(ISchematicObj conn) {
        if (conn == this.get(ROOM)) {
            this.pauseUpdates();
            this.set(ROOM, null);
            this.set(ROOM_NORMAL, GeomConstants.VEC3D_ZPOS);
            this.changedEvt(new Object[0]);
            this.resumeUpdates();
        }
    }

    @Override
    public void connectTo(ISchematicObj conn) {
    }

    @Override
    public boolean updateTopo() {
        Point3d location = this.get(LOCATION);
        GeomUtil.FindResult room = GeomUtil.findRoom((VentusData)this.getDomain(), new Point3d(location.x, location.y, location.z + 1.0E-6), new Point3d(location.x, location.y, location.z - 1.0E-6), 1, SourceSink.getRoomFilter());
        if (room != null) {
            this.pauseUpdates();
            this.set(ROOM, room.room);
            this.set(ROOM_NORMAL, room.faceNormal);
            this.set(LOCATION, room.p);
            this.resumeUpdates();
        }
        return true;
    }

    @Override
    public void update(Events events) {
        if (events.isChanged(this.get(ELEMENT), SourceSinkElement.COLOR)) {
            this.changedEvt(ELEMENT);
        }
    }

    public static BiPredicate<? super ISchematicRoom, ? super ISchematicRoom.IComponent> getRoomFilter() {
        return (room, comp) -> room.getType() == ISchematicRoom.Type.ZONE && !(comp instanceof ISchematicRoom.IWallComponent);
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getPointGeom());
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        if (geom instanceof PointEntityGeom) {
            PointEntityGeom pointGeom = (PointEntityGeom)geom;
            this.set(LOCATION, pointGeom.location);
        }
        this.changedEvt(VentusData.TOPOLOGY);
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        IGeomNode geom = this.getGeom();
        PropsBuilder pb = new PropsBuilder();
        SourceSinkElement sourceSinkElement = this.get(ELEMENT);
        if (sourceSinkElement instanceof SourceSinkElement) {
            SourceSinkElement elem = sourceSinkElement;
            pb.add(new IPrimProps.Face(elem.get(SourceSinkElement.COLOR), null, 0), 12);
        } else {
            pb.add(new IPrimProps.Face(Color.RED, null, 0), 12);
        }
        pb.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0), 18);
        return new DisplayGeom(geom, pb);
    }

    private SourceSinkGeom getPointGeom() {
        return new SourceSinkGeom((VentusData)this.getDomain(), this.get(LOCATION));
    }

    public PropertyDefs<SourceSink> getPropertyDefs() {
        return PROP_TYPES;
    }

    @Override
    public SourceSink clone() {
        return (SourceSink)super.clone();
    }

    @Override
    public void readTopology(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        if (VentusOIS.isPrior(ois, VentusIO.Version.VER_215)) {
            this.set(ROOM, (ISchematicRoom)ois.readObject());
        } else {
            super.readTopology(ois);
        }
    }

    private static class SourceSinkGeom
    extends PointEntityGeom {
        private static final long serialVersionUID = 1L;
        private final VentusData vd;

        public SourceSinkGeom(VentusData vd, Point3d loc) {
            super(loc, 0.6);
            this.vd = vd;
        }

        @Override
        public PointEntityGeom newPoint(Point3d loc) {
            return new SourceSinkGeom(this.vd, loc);
        }

        @Override
        public void generateManipHandles(Consumer<? super IHandle> handles) {
            handles.accept(new Handle());
        }

        public class Handle
        extends PointEntityGeom.Handle {
            public Handle() {
                super(SourceSinkGeom.this);
            }

            @Override
            public Pair<SnapMode, IIsectFilter> getPickFilter() {
                return new Pair<SnapMode, IIsectFilter>(SnapMode.FILTERED_TWO_PASS, new DefaultFilter());
            }

            @Override
            public ISnapConstraint getConstraint(Point3d handleLoc) {
                return new RoomSnapConstraint(SourceSinkGeom.this.vd, null, AHSPoint.getRoomFilter());
            }
        }
    }
}

