/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.simparams;

import java.util.Map;
import org.jscience.physics.units.SI;
import thunderheadeng.util.TypedProp;
import ventus.VentusApp;
import ventus.data.VentusData;
import ventus.feature.comps.DefaultFlatDataModel;
import ventus.feature.comps.IPrjDataWriter;
import ventus.feature.simparams.SimParamsProps;
import ventus.io.contamx.PrjData;
import ventus.io.contamx.PrjUtil;

public class PrjDataWriterSimParamsComp
implements IPrjDataWriter {
    private final DefaultFlatDataModel<SimParamsProps> d_dm;

    public PrjDataWriterSimParamsComp(DefaultFlatDataModel<SimParamsProps> dm) {
        this.d_dm = dm;
    }

    @Override
    public IPrjDataWriter.Order getOrder() {
        return IPrjDataWriter.Order.NORMAL;
    }

    @Override
    public void addPrjData(VentusApp app, VentusData md, Map<TypedProp, Object> scenario, PrjData prjData) {
        String timestep;
        SimParamsProps props = this.d_dm.getProps(md);
        prjData.sim_af = switch (props.get(SimParamsProps.airflowSimMethod)) {
            default -> throw new MatchException(null, null);
            case SimParamsProps.AirflowSimMethod.STEADY -> 0;
            case SimParamsProps.AirflowSimMethod.TRANSIENT -> 1;
        };
        PrjData.LinearSolverContam linearSolverContam = prjData.cyclic;
        linearSolverContam.sim_mf = switch (props.get(SimParamsProps.contaminantSimMethod)) {
            default -> throw new MatchException(null, null);
            case SimParamsProps.ContaminantSimMethod.STEADY -> 1;
            case SimParamsProps.ContaminantSimMethod.TRANSIENT -> 2;
        };
        prjData.time1 = PrjUtil.convertTimeDuration(props.get(SimParamsProps.simulationTime));
        prjData.tStep = timestep = PrjUtil.convertTimeDuration(props.get(SimParamsProps.simulationTimestep));
        prjData.tList = timestep;
        prjData.tScrn = timestep;
        prjData.cnvgSS = props.get(SimParamsProps.runSteady) != false ? 1 : 0;
        prjData.tsdens = props.get(SimParamsProps.varyDensity) != false ? 1 : 0;
        prjData.tsmaxi = props.get(SimParamsProps.maxIteration);
        if (props.get(SimParamsProps.varyDensity).booleanValue()) {
            prjData.densZP = 1;
            prjData.dodMdt = 1;
        }
        prjData.T = props.get(SimParamsProps.defaultZoneTemp).get(SI.KELVIN);
        prjData.uT = 0;
    }
}

