/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.results;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.miginfocom.swing.MigLayout;
import thunderheadeng.gui.ColorIcon;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiUnitDoubleField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.TypedProp;
import ventus.actions.CompElementActions;
import ventus.data.IMerlinObj;
import ventus.feature.comps.ISelectionRibbon;
import ventus.feature.results.NodeProps;
import ventus.gui.MerlinUDF;
import ventus.gui.guiUtil;
import ventus.mv.gui.PropConnections;
import ventus.mv.gui.SelectionEditorPanel;

class ZoneSelectionRibbon
implements ISelectionRibbon {
    ZoneSelectionRibbon() {
    }

    @Override
    public boolean isEnabled(Set<TypedProp<?>> shared, Set<TypedProp<?>> unshared) {
        return shared.contains(NodeProps.TEMPERATURE) && shared.contains(NodeProps.PRESSURE) && shared.contains(NodeProps.DENSITY) && !shared.contains(NodeProps.FLOW0);
    }

    @Override
    public Collection<SelectionEditorPanel.EditorPanel> getSections() {
        MerlinUDF temp = new MerlinUDF(14);
        temp.setEditable(false);
        MerlinUDF pres = new MerlinUDF(15);
        pres.setEditable(false);
        MerlinUDF dens = new MerlinUDF(22);
        dens.setEditable(false);
        Dimension prefSize = new Dimension((int)((double)temp.getPreferredSize().width * 1.25), temp.getPreferredSize().height);
        temp.setPreferredSize(prefSize);
        pres.setPreferredSize(prefSize);
        dens.setPreferredSize(prefSize);
        SelectionEditorPanel.EditorPanel panel = new SelectionEditorPanel.EditorPanel();
        this.bind(panel, NodeProps.TEMPERATURE, temp);
        this.bind(panel, NodeProps.PRESSURE, pres);
        this.bind(panel, NodeProps.DENSITY, dens);
        panel.setLayout(new MigLayout(""));
        int squareIconDim = 16;
        ColorIcon tempIcon = new ColorIcon(Color.RED, squareIconDim, squareIconDim, 1);
        ColorIcon presIcon = new ColorIcon(Color.CYAN, squareIconDim, squareIconDim, 1);
        ColorIcon densIcon = new ColorIcon(Color.GRAY, squareIconDim, squareIconDim, 1);
        guiLabel tempLabel = guiUtil.lblProp(NodeProps.TEMPERATURE);
        guiLabel presLabel = guiUtil.lblProp(NodeProps.PRESSURE);
        guiLabel densLabel = guiUtil.lblProp(NodeProps.DENSITY);
        tempLabel.setIcon(tempIcon);
        presLabel.setIcon(presIcon);
        densLabel.setIcon(densIcon);
        panel.add((Component)tempLabel, "growy");
        panel.add((Component)temp, "grow");
        panel.add((Component)presLabel, "growy, newline");
        panel.add((Component)pres, "grow");
        panel.add((Component)densLabel, "growy");
        panel.add((Component)dens, "grow");
        return List.of(panel);
    }

    private void bind(SelectionEditorPanel.EditorPanel editor, TypedProp<UnitDouble> prop, guiUnitDoubleField control) {
        PropConnections.UDPropConnection binding = new PropConnections.UDPropConnection((CompElementActions.IObjectProp<IMerlinObj, UnitDouble>)new CompElementActions.DefProp<IMerlinObj, UnitDouble>(prop), control);
        editor.addConnection(binding);
    }
}

