/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.results;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventRecord;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AVisibilityAction;
import ventus.actions.Hide;
import ventus.actions.Show;
import ventus.actions.UIHook;
import ventus.data.VentusData;
import ventus.feature.comps.IDefaultAction;
import ventus.feature.results.DataNode;

public class ToggleVectorAction
extends AVisibilityAction
implements IDefaultAction {
    public static final UIHook UI_HOOK = new UIHook(new ToggleVectorAction(), Intl.intl("Toggle Vector"));

    @Override
    public Collection<UIHook> getDoubleClickActions() {
        return Arrays.asList(UI_HOOK);
    }

    public ToggleVectorAction() {
        super(true);
    }

    @Override
    public void run(VentusApp app, VentusData md) {
        Set selected = md.selection.getSelected(DataNode.VisLeaf.class);
        if (selected != null && selected.size() == 1) {
            DataNode.VisLeaf visLeaf = (DataNode.VisLeaf)selected.iterator().next();
            if (visLeaf.isVisible()) {
                Hide.hide(app, md, selected);
            } else {
                Show.show(app, md, selected);
            }
        }
    }

    @Override
    public void update(Events events) {
        IEventRecord<IDomainObject> changelog = events.getEvents(IDomainObject.class, new Class[0]);
        if (changelog.containsChange(VentusData.SELECTION_CHANGED) || changelog.containsChange(VentusData.MODEL_RESET) || changelog.containsChange(VentusData.MODEL_LOADED)) {
            VentusData md = VentusApp.getAppData();
            assert (md != null);
            UI_HOOK.setEnabled(md.selection.isSingleExclusive(DataNode.VisLeaf.class) || md.selection.isSingleExclusive(DataNode.VisLeaf.class));
        }
    }
}

