/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.results;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.util.Events;
import thunderheadeng.util.GroupedSequence;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.actions.Visibility;
import ventus.data.VentusData;
import ventus.feature.comps.IContextMenuItem;
import ventus.feature.comps.IDefaultAction;
import ventus.feature.results.DataNode;
import ventus.gui.ContextMenuUtils;

class ShowResultsAction
implements IContextMenuItem,
IDefaultAction,
IEventObserver {
    final UIHook showResults = new UIHook(new ShowResults(), Intl.intl("Show Results"));

    @Override
    public Collection<UIHook> getDoubleClickActions() {
        return Arrays.asList(this.showResults);
    }

    @Override
    public void update(Events events) {
        IEventRecord<IDomainObject> changelog = events.getEvents(IDomainObject.class, new Class[0]);
        if (changelog.containsChange(VentusData.SELECTION_CHANGED) || changelog.containsChange(VentusData.MODEL_RESET) || changelog.containsChange(VentusData.MODEL_LOADED)) {
            VentusData md = VentusApp.getAppData();
            assert (md != null);
            this.updateEnabled(md);
        }
    }

    private void updateEnabled(VentusData md) {
        boolean enabledFlag = md.selection.isSingleExclusive(DataNode.SimulationRoot.class, DataNode.VisRoot.class);
        this.showResults.setEnabled(enabledFlag);
    }

    @Override
    public void addContextMenuItem(GroupedSequence root) {
        root.getNode(ContextMenuUtils.ContextMenuNode.EDIT.id).add(this.showResults);
    }

    private static class ShowResults
    extends AMerlinOp {
        private ShowResults() {
        }

        @Override
        public void run(VentusApp app, VentusData md) {
            Set targets = md.selection.getSelected(DataNode.class);
            assert (targets.size() == 1);
            DataNode target = (DataNode)targets.iterator().next();
            while (!DataNode.SimulationRoot.class.isInstance(target)) {
                target = (DataNode)md.hierarchy.getParent(target);
            }
            Set<DataNode> toShow = Collections.singleton(target);
            DataNode.ResultsRoot root = (DataNode.ResultsRoot)md.hierarchy.getParent(target);
            Collection<DataNode.SimulationRoot> toHide = root.flatten(DataNode.SimulationRoot.class, obj -> !toShow.contains(obj));
            try (VentusData.WriteLock ignored = md.lockWrite();){
                Undo.begin(Intl.intl("Show Results"));
                Undo.insertUndoEntry_restoreSelection(md);
                md.selection.clear();
                Visibility.setVisibility(md, toShow, toHide, true);
                Undo.end(md);
            }
        }
    }
}

