/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.results;

import java.awt.EventQueue;
import java.util.Collection;
import java.util.function.Predicate;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.Predicates;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.UIHook;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.feature.VentusEvents;
import ventus.feature.results.DataNode;
import ventus.feature.results.DataNodeAnimator;
import ventus.feature.results.ResultsDataComp;
import ventus.util.MerlinUtil;

public class ResultsModelChangeObserver
implements IEventObserver {
    private static final Predicate<Object> s_ignoreFilter = Predicates.or(Filters.accept(VentusData.SELECTION_CHANGED, VentusData.PREFS_CHANGED, DataNodeAnimator.ANIMATION_CHANGED), MerlinUtil::isVisibilityEvent);

    @Override
    public void update(Events events) {
        boolean isStale;
        IEventRecord<IDomainObject> domainRecord = events.getEvents(IDomainObject.class, new Class[0]);
        if (domainRecord.containsChange(VentusData.MODEL_RESET) || domainRecord.containsChange(VentusData.MODEL_LOADED) || domainRecord.containsChange(VentusData.MODEL_SAVED)) {
            return;
        }
        boolean canIgnore = domainRecord.allChangesMatch(s_ignoreFilter);
        if (canIgnore) {
            return;
        }
        IEventRecord<IMerlinObj> eventRecord = events.getEvents(IMerlinObj.class, DataNode.class);
        if (eventRecord.containsChange(VentusEvents.SimulationComplete.class)) {
            return;
        }
        boolean bl = isStale = eventRecord.hasChangedObjs() || eventRecord.hasAddedObjs() || eventRecord.hasRemovedObjs();
        if (isStale) {
            EventQueue.invokeLater(() -> {
                MarkStaleOp op = new MarkStaleOp(true);
                UIHook.run(null, op.getName(), op, 20);
            });
        }
    }

    private static class MarkStaleOp
    extends AMerlinOp {
        private final boolean stale;

        public MarkStaleOp(boolean stale) {
            this.stale = stale;
        }

        public String getName() {
            return String.valueOf(this.getClass()) + "::" + (this.stale ? "stale" : "fresh");
        }

        @Override
        public void run(VentusApp ventusApp, VentusData ventusData) {
            try (VentusData.WriteLock lock = ventusData.lockWrite();){
                DataNode.ResultsRoot root = (DataNode.ResultsRoot)ventusData.getComponentData(ResultsDataComp.GUID);
                Collection<DataNode.StaleLeaf> leaves = root.flatten(DataNode.StaleLeaf.class);
                for (DataNode.StaleLeaf leaf : leaves) {
                    leaf.setStale(this.stale);
                }
            }
        }
    }
}

